/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Trace id and reason code definitions.
 *
 * This file is generated by mktrace.
 * ------>>> DO NOT EDIT ! <<<------
 */
#include <DirIds.h>
#define LOCAL_BASE	DIR_ID_KERNEXT_GPL_LINUX
#define LOCAL_TRCID	(LOCAL_BASE << 10)
#define TRCID_CXIINC_COUNTER	(LOCAL_TRCID + 1)
#define TRCID_GPFSINIT_000	(LOCAL_TRCID + 2)
#define TRCID_PORTINIT_001	(LOCAL_TRCID + 3)
#define TRCID_FILE_001	(LOCAL_TRCID + 4)
#define TRCID_FILE_003	(LOCAL_TRCID + 5)
#define TRCID_FILE_005	(LOCAL_TRCID + 6)
#define TRCID_FILE_071	(LOCAL_TRCID + 7)
#define TRCID_FILE_0712	(LOCAL_TRCID + 8)
#define TRCID_FILE_072	(LOCAL_TRCID + 9)
#define TRCID_BLOCK_005	(LOCAL_TRCID + 10)
#define TRCID_BLOCK_0051	(LOCAL_TRCID + 11)
#define TRCID_BLOCK_071	(LOCAL_TRCID + 12)
#define TRCID_BLOCK_0712	(LOCAL_TRCID + 13)
#define TRCID_BLOCK_072	(LOCAL_TRCID + 14)
#define TRCID_BLOCK_073	(LOCAL_TRCID + 15)
#define TRCID_BLOCK_074	(LOCAL_TRCID + 16)
#define TRCID_BLOCK_011	(LOCAL_TRCID + 17)
#define TRCID_BLOCK_013	(LOCAL_TRCID + 18)
#define TRCID_BLOCK_015	(LOCAL_TRCID + 19)
#define TRCID_INVAL_DCACHE	(LOCAL_TRCID + 20)
#define TRCID_INVAL_DUNCACHE	(LOCAL_TRCID + 21)
#define TRCID_INVAL_DCACHE_NOPRUNE	(LOCAL_TRCID + 22)
#define TRCID_DROP_INVAL_DCACHE	(LOCAL_TRCID + 23)
#define TRCID_DROP_DUNCACHE	(LOCAL_TRCID + 24)
#define TRCID_INVAL_NEG_DCACHE	(LOCAL_TRCID + 25)
#define TRCID_DIR_001	(LOCAL_TRCID + 26)
#define TRCID_LINUXOPS_LLSEEK_ENTER	(LOCAL_TRCID + 27)
#define TRCID_LINUXOPS_LLSEEK_EXIT	(LOCAL_TRCID + 28)
#define TRCID_LINUXOPS_READDIR_ENTER	(LOCAL_TRCID + 29)
#define TRCID_LINUXOPS_READDIR_EXIT	(LOCAL_TRCID + 30)
#define TRCID_LINUXOPS_POLL	(LOCAL_TRCID + 31)
#define TRCID_LINUXOPS_IOCTL	(LOCAL_TRCID + 32)
#define TRCID_LINUXOPS_MAP_ENTER	(LOCAL_TRCID + 33)
#define TRCID_LINUXOPS_MAP_EXIT	(LOCAL_TRCID + 34)
#define TRCID_LINUXOPS_NOPAGE	(LOCAL_TRCID + 35)
#define TRCID_LINUXOPS_NOPAGE1	(LOCAL_TRCID + 36)
#define TRCID_LINUXOPS_NOPAGE_NULL	(LOCAL_TRCID + 37)
#define TRCID_LINUXOPS_PAGE	(LOCAL_TRCID + 38)
#define TRCID_FM_OPEN	(LOCAL_TRCID + 39)
#define TRCID_FM_OPEN_EXIT	(LOCAL_TRCID + 40)
#define TRCID_FM_CLOSE_ENTER	(LOCAL_TRCID + 41)
#define TRCID_FM_CLOSE_ENTER1	(LOCAL_TRCID + 42)
#define TRCID_FM_CLOSE	(LOCAL_TRCID + 43)
#define TRCID_LINUXOPS_MMAP_ENTER	(LOCAL_TRCID + 44)
#define TRCID_LINUXOPS_MMAP_ENTER_A	(LOCAL_TRCID + 45)
#define TRCID_LINUXOPS_MMAP_ENTER_A1	(LOCAL_TRCID + 46)
#define TRCID_LINUXOPS_MMAP_EXIT	(LOCAL_TRCID + 47)
#define TRCID_LINUXOPS_OPEN_ENTER	(LOCAL_TRCID + 48)
#define TRCID_LINUXOPS_OPEN_01	(LOCAL_TRCID + 49)
#define TRCID_LINUXOPS_OPEN_EXIT	(LOCAL_TRCID + 50)
#define TRCID_LINUXOPS_CLOSE_ENTER	(LOCAL_TRCID + 51)
#define TRCID_CLOSE_EXIT	(LOCAL_TRCID + 52)
#define TRCID_LINUXOPS_FSYNC_ENTER	(LOCAL_TRCID + 53)
#define TRCID_LINUXOPS_FSYNC_EXIT	(LOCAL_TRCID + 54)
#define TRCID_LINUXOPS_FASYNC_ENTER	(LOCAL_TRCID + 55)
#define TRCID_LINUXOPS_FASYNC_EXIT	(LOCAL_TRCID + 56)
#define TRCID_LINUXOPS_MEDIA	(LOCAL_TRCID + 57)
#define TRCID_LINUXOPS_REVALIDATE_DEV	(LOCAL_TRCID + 58)
#define TRCID_LINUXOPS_LOCKCTL_ENTER	(LOCAL_TRCID + 59)
#define TRCID_LINUXOPS_LOCKCTL_ENTER2	(LOCAL_TRCID + 60)
#define TRCID_LINUXOPS_LOCKCTL_ENTER3	(LOCAL_TRCID + 61)
#define TRCID_LINUXOPS_LOCKCTL_DIAG2	(LOCAL_TRCID + 62)
#define TRCID_LINUXOPS_LOCKCTL_EXIT	(LOCAL_TRCID + 63)
#define TRCID_LINUXOPS_RDWRINT_ENTER	(LOCAL_TRCID + 64)
#define TRCID_LINUXOPS_RDWRINT_EXIT	(LOCAL_TRCID + 65)
#define TRCID_LINUXOPS_READ_DIR	(LOCAL_TRCID + 66)
#define TRCID_PRINTINODE_1	(LOCAL_TRCID + 67)
#define TRCID_PRINTINODE_2	(LOCAL_TRCID + 68)
#define TRCID_PRINTINODE_3	(LOCAL_TRCID + 69)
#define TRCID_PRINTINODE_4	(LOCAL_TRCID + 70)
#define TRCID_PRINTINODE_5	(LOCAL_TRCID + 71)
#define TRCID_PRINTDENTRY_1	(LOCAL_TRCID + 72)
#define TRCID_PRINTDENTRY_2a	(LOCAL_TRCID + 73)
#define TRCID_PRINTDENTRY_2	(LOCAL_TRCID + 74)
#define TRCID_PRINTDENTRY_3	(LOCAL_TRCID + 75)
#define TRCID_PRINTDENTRY_4a	(LOCAL_TRCID + 76)
#define TRCID_PRINTDENTRY_4	(LOCAL_TRCID + 77)
#define TRCID_PRINTDENTRY_5	(LOCAL_TRCID + 78)
#define TRCID_LINUXOPS_SETINODE	(LOCAL_TRCID + 79)
#define TRCID_CXIINVA_PERM	(LOCAL_TRCID + 80)
#define TRCID_LINUXOPS_CREATE_ENTER	(LOCAL_TRCID + 81)
#define TRCID_LINUXOPS_CREATE_EXIT	(LOCAL_TRCID + 82)
#define TRCID_LINUXOPS_LOOKUP_ENTER	(LOCAL_TRCID + 83)
#define TRCID_LINUXOPS_LOOKUP_STALE	(LOCAL_TRCID + 84)
#define TRCID_LINUXOPS_LOOKUP_EXIT	(LOCAL_TRCID + 85)
#define TRCID_LINUXOPS_LINK_ENTER	(LOCAL_TRCID + 86)
#define TRCID_LINUXOPS_LINK_EXIT	(LOCAL_TRCID + 87)
#define TRCID_LINUXOPS_UNLINK_ENTER	(LOCAL_TRCID + 88)
#define TRCID_LINUXOPS_UNLINK_EXIT	(LOCAL_TRCID + 89)
#define TRCID_LINUXOPS_SYMLINK1	(LOCAL_TRCID + 90)
#define TRCID_LINUXOPS_SYMLINK2	(LOCAL_TRCID + 91)
#define TRCID_LINUXOPS_SYMLINK_EXIT	(LOCAL_TRCID + 92)
#define TRCID_LINUXOPS_MKDIR_ENTER	(LOCAL_TRCID + 93)
#define TRCID_LINUXOPS_MKDIR_EXIT	(LOCAL_TRCID + 94)
#define TRCID_LINUXOPS_RMDIR_ENTER	(LOCAL_TRCID + 95)
#define TRCID_LINUXOPS_RMDIR_EXIT	(LOCAL_TRCID + 96)
#define TRCID_LINUXOPS_MKNOD_ENTER	(LOCAL_TRCID + 97)
#define TRCID_LINUXOPS_MKNOD_EXIT	(LOCAL_TRCID + 98)
#define TRCID_LINUXOPS_RENAME_1	(LOCAL_TRCID + 99)
#define TRCID_LINUXOPS_RENAME_2	(LOCAL_TRCID + 100)
#define TRCID_LINUXOPS_RENAME_EXIT	(LOCAL_TRCID + 101)
#define TRCID_LINUXOPS_READLINK_ENTER	(LOCAL_TRCID + 102)
#define TRCID_LINUXOPS_READLINK_EXIT	(LOCAL_TRCID + 103)
#define TRCID_LINUXOPS_FOLLOW_LINK_ENTER	(LOCAL_TRCID + 104)
#define TRCID_LINUXOPS_FOLLOW_LINK_1	(LOCAL_TRCID + 105)
#define TRCID_LINUXOPS_FOLLOW_LINK_2	(LOCAL_TRCID + 106)
#define TRCID_LINUXOPS_READPAGE_ENTER	(LOCAL_TRCID + 107)
#define TRCID_LINUXOPS_READPAGE_ENTER_A	(LOCAL_TRCID + 108)
#define TRCID_LINUXOPS_READPAGE_EXIT	(LOCAL_TRCID + 109)
#define TRCID_LINUXOPS_WRPAGE_ENTER	(LOCAL_TRCID + 110)
#define TRCID_LINUXOPS_WRPAGE_ENTER_A	(LOCAL_TRCID + 111)
#define TRCID_LINUXOPS_WRPAGE_EXIT	(LOCAL_TRCID + 112)
#define TRCID_LINUXOPS_TRUNCATE_PAGE_ENTER	(LOCAL_TRCID + 113)
#define TRCID_LINUXOPS_BMAP	(LOCAL_TRCID + 114)
#define TRCID_LINUXOPS_TRUNCATE	(LOCAL_TRCID + 115)
#define TRCID_LINUXOPS_ACCESS_ENTER	(LOCAL_TRCID + 116)
#define TRCID_LINUXOPS_ACCESS_EXIT	(LOCAL_TRCID + 117)
#define TRCID_LINUXOPS_SMAP	(LOCAL_TRCID + 118)
#define TRCID_LINUXOPS_UPDATEPAGE	(LOCAL_TRCID + 119)
#define TRCID_LINUXOPS_REVALIDATE_ENTER	(LOCAL_TRCID + 120)
#define TRCID_LINUXOPS_REVALIDATE_STALE	(LOCAL_TRCID + 121)
#define TRCID_REVAL_DELAY	(LOCAL_TRCID + 122)
#define TRCID_REVAL_DELAY_END	(LOCAL_TRCID + 123)
#define TRCID_LINUXOPS_REVALIDATE_EXIT	(LOCAL_TRCID + 124)
#define TRCID_LINUXOPS_SETATTR_ENTER	(LOCAL_TRCID + 125)
#define TRCID_LINUXOPS_SETATTR_EXIT	(LOCAL_TRCID + 126)
#define TRCID_LINUXOPS_GETATTR_ENTER	(LOCAL_TRCID + 127)
#define TRCID_LINUXOPS_GETATTR_EXIT	(LOCAL_TRCID + 128)
#define TRCID_VNODE_BKL	(LOCAL_TRCID + 129)
#define TRCID_LINUXOPS_READINODE_ENTER	(LOCAL_TRCID + 130)
#define TRCID_LINUXOPS_NEW_VNODE_1	(LOCAL_TRCID + 131)
#define TRCID_LINUXOPS_READINODE_EXIT	(LOCAL_TRCID + 132)
#define TRCID_LINUXOPS_READINODE_HUH	(LOCAL_TRCID + 133)
#define TRCID_LINUXOPS_DELETE_INODE	(LOCAL_TRCID + 134)
#define TRCID_LINUXOPS_DELETE_INODE_1	(LOCAL_TRCID + 135)
#define TRCID_LINUXOPS_NOTIFY_ENTER	(LOCAL_TRCID + 136)
#define TRCID_LINUXOPS_NOTIFY_EXIT	(LOCAL_TRCID + 137)
#define TRCID_LINUXOPS_PUTSUPER_ENTER	(LOCAL_TRCID + 138)
#define TRCID_LINUXOPS_PUTSUPER_EXIT	(LOCAL_TRCID + 139)
#define TRCID_LINUXOPS_STATFS_ENTER	(LOCAL_TRCID + 140)
#define TRCID_LINUXOPS_STATFS_EXIT	(LOCAL_TRCID + 141)
#define TRCID_LINUXOPS_UMOUNT_ENTER	(LOCAL_TRCID + 142)
#define TRCID_LINUXOPS_UMOUNT_EXIT	(LOCAL_TRCID + 143)
#define TRCID_LINUXOPS_REMOUNT	(LOCAL_TRCID + 144)
#define TRCID_LINUXOPS_WRITEINODE	(LOCAL_TRCID + 145)
#define TRCID_LINUXOPS_CLEARINODE	(LOCAL_TRCID + 146)
#define TRCID_LINUXOPS_CLEARINODE_DETAILS	(LOCAL_TRCID + 147)
#define TRCID_LINUXOPS_CLEARINODE_EXIT	(LOCAL_TRCID + 148)
#define TRCID_LINUXOPS_WRITESUPER	(LOCAL_TRCID + 149)
#define TRCID_LINUXOPS_WRITESUPER_3	(LOCAL_TRCID + 150)
#define TRCID_LINUXOPS_WRITESUPER_5	(LOCAL_TRCID + 151)
#define TRCID_LINUXOPS_READSUPER_1	(LOCAL_TRCID + 152)
#define TRCID_LINUXOPS_READSUPER_2	(LOCAL_TRCID + 153)
#define TRCID_LINUXOPS_READSUPER_STARTHELPER	(LOCAL_TRCID + 154)
#define TRCID_LINUXOPS_READSUPER_HELPERRC	(LOCAL_TRCID + 155)
#define TRCID_LINUXOPS_READSUPER_SUCCEED	(LOCAL_TRCID + 156)
#define TRCID_LINUXOPS_READSUPER_FAILED	(LOCAL_TRCID + 157)
#define TRCID_LINUXOPS_REGFS	(LOCAL_TRCID + 158)
#define TRCID_LINUXOPS_UNREGFS	(LOCAL_TRCID + 159)
#define TRCID_LINUXOPS_MMFSD_RELEASE_1	(LOCAL_TRCID + 160)
#define TRCID_LINUXOPS_MMFSD_RELEASE_2	(LOCAL_TRCID + 161)
#define TRCID_LINUXOPS_MMFSD_RELEASE_3	(LOCAL_TRCID + 162)
#define TRCID_LINUXOPS_KILLMMFSD	(LOCAL_TRCID + 163)
#define TRCID_SWAPD_CLEARINODE	(LOCAL_TRCID + 164)
#define TRCID_SWAPD_READINODE	(LOCAL_TRCID + 165)
#define TRCID_ADDOSNODE_UNUSED	(LOCAL_TRCID + 166)
#define TRCID_LINUXOPS_EXECMMFS_1	(LOCAL_TRCID + 167)
#define TRCID_LINUXOPS_EXECMMFS_EXIT	(LOCAL_TRCID + 168)
#define TRCID_LINUXOPS_FORK_MOUNTHELPER	(LOCAL_TRCID + 169)
#define TRCID_SET_MOUNT_INFO	(LOCAL_TRCID + 170)
#define TRCID_LINUXOPS_UNMOUNTINT_ENTER	(LOCAL_TRCID + 171)
#define TRCID_LINUXOPS_UNMOUNTINT_EXIT	(LOCAL_TRCID + 172)
#define TRCID_LINUXOPS_REACTIVATE_VNODE	(LOCAL_TRCID + 173)
#define TRCID_LINUXOPS_NEW_VNODE	(LOCAL_TRCID + 174)
#define TRCID_LINUXOPS_NEW_VNODE_EXIT	(LOCAL_TRCID + 175)
#define TRCID_LINUXOPS_NEW_VNODE_BAD	(LOCAL_TRCID + 176)
#define TRCID_LINUXOPS_DELETE_VNODE	(LOCAL_TRCID + 177)
#define TRCID_LINUXOPS_DELETE_MMAP	(LOCAL_TRCID + 178)
#define TRCID_LINUXOPS_REINIT_VNODE	(LOCAL_TRCID + 179)
#define TRCID_LINUXOPS_FIND_VNODE	(LOCAL_TRCID + 180)
#define TRCID_LINUXOPS_DUMP_VNODE	(LOCAL_TRCID + 181)
#define TRCID_LINUXOPS_REF_VNODE	(LOCAL_TRCID + 182)
#define TRCID_LINUXOPS_INACTIVE_VNODE	(LOCAL_TRCID + 183)
#define TRCID_LINUXOPS_PUT_OSNODE	(LOCAL_TRCID + 184)
#define TRCID_LINUXOPS_DESTROY_OSNODE	(LOCAL_TRCID + 185)
#define TRCID_CXIUPDATE_INODE_2	(LOCAL_TRCID + 186)
#define TRCID_CXIUPDATE_INODE_1	(LOCAL_TRCID + 187)
#define TRCID_LINUXOPS_CANUNCACHE_OSNODE	(LOCAL_TRCID + 188)
#define TRCID_LINUXOPS_ADD_OSNODE	(LOCAL_TRCID + 189)
#define TRCID_FCNTLLOCK_ENTER	(LOCAL_TRCID + 190)
#define TRCID_FCNTLLOCK_GETLK	(LOCAL_TRCID + 191)
#define TRCID_FCNTLLOCK_EXIT	(LOCAL_TRCID + 192)
#define TRCID_SLEEP	(LOCAL_TRCID + 193)
#define TRCID_SLEEP_END	(LOCAL_TRCID + 194)
#define TRCID_OPENNFS	(LOCAL_TRCID + 195)
#define TRCID_CXISTART_KPROC_LINUX	(LOCAL_TRCID + 196)
#define TRCID_CXISTOP_KPROC_LINUX	(LOCAL_TRCID + 197)
#define TRCID_CXISTOP_KPROC_STILL_ALIVE	(LOCAL_TRCID + 198)
#define TRCID_PANIC	(LOCAL_TRCID + 199)
#define TRCID_MODULE_LOGASSERT_1	(LOCAL_TRCID + 200)
#define TRCID_MODULE_LOGASSERT_2	(LOCAL_TRCID + 201)
#define TRCID_CXISYSTEM_001	(LOCAL_TRCID + 202)
#define TRCID_CXISYSTEM_003	(LOCAL_TRCID + 203)
#define TRCID_CXISYSTEM_SUNLOCK	(LOCAL_TRCID + 204)
#define TRCID_CXISYSTEM_SUNLOCK_EXIT	(LOCAL_TRCID + 205)
#define TRCID_CXISYSTEM_SLEEP_THREAD_ENTER	(LOCAL_TRCID + 206)
#define TRCID_CXISYSTEM_SLEEP_THREAD_EXIT	(LOCAL_TRCID + 207)
#define TRCID_CXISYSTEM_WAKEUP	(LOCAL_TRCID + 208)
#define TRCID_CXISYSTEM_WAKEUP_ONE	(LOCAL_TRCID + 209)
#define TRCID_CXISYSTEM_WAKEUP_RESULT	(LOCAL_TRCID + 210)
#define TRCID_CXISYSTEM_037	(LOCAL_TRCID + 211)
#define TRCID_CXISYSTEM_039a	(LOCAL_TRCID + 212)
#define TRCID_CXISYSTEM_039	(LOCAL_TRCID + 213)
#define TRCID_CXISYSTEM_041a	(LOCAL_TRCID + 214)
#define TRCID_CXISYSTEM_041	(LOCAL_TRCID + 215)
#define TRCID_CXISYSTEM_CHKTYPES	(LOCAL_TRCID + 216)
#define TRCID_BM_INIT	(LOCAL_TRCID + 217)
#define TRCID_BM_ACQ	(LOCAL_TRCID + 218)
#define TRCID_BM_ACQ_EXIT	(LOCAL_TRCID + 219)
#define TRCID_BM_REL	(LOCAL_TRCID + 220)
#define TRCID_BM_TERM	(LOCAL_TRCID + 221)
#define TRCID_CXISYSTEM_017	(LOCAL_TRCID + 222)
#define TRCID_CXISYSTEM_018	(LOCAL_TRCID + 223)
#define TRCID_CXISYSTEM_EVENT_WAIT_ENTER	(LOCAL_TRCID + 224)
#define TRCID_CXISYSTEM_EVENT_WAIT_EXIT	(LOCAL_TRCID + 225)
#define TRCID_CXISYSTEM_SIGNAL	(LOCAL_TRCID + 226)
#define TRCID_CXISYSTEM_BROADCAST	(LOCAL_TRCID + 227)
#define TRCID_CXISYSTEM_BROADCAST_RC	(LOCAL_TRCID + 228)
#define TRCID_SMBOPENLOCKCONTROL_1	(LOCAL_TRCID + 229)
#define TRCID_SMBOPENLOCKCONTROL_EXIT	(LOCAL_TRCID + 230)
#define TRCID_SMBOPENLOCKMOVE_1	(LOCAL_TRCID + 231)
#define TRCID_SMBOPENLOCKMOVE_EXIT	(LOCAL_TRCID + 232)
#define TRCID_CXICHECKOPEN_ENTRY	(LOCAL_TRCID + 233)
#define TRCID_CXICHECKOPEN_FOUND	(LOCAL_TRCID + 234)
#define TRCID_KIBD_NEW	(LOCAL_TRCID + 235)
#define TRCID_KIBD_DELETE	(LOCAL_TRCID + 236)
#define TRCID_DEALLOC_KIBD_1	(LOCAL_TRCID + 237)
#define TRCID_DEALLOC_KIBD_2	(LOCAL_TRCID + 238)
#define TRCID_ALLOC_KIBD_1	(LOCAL_TRCID + 239)
#define TRCID_ALLOC_KIBD_2	(LOCAL_TRCID + 240)
#define TRCID_ALLOC_KIBD_UNCACHE	(LOCAL_TRCID + 241)
#define TRCID_KIBD_INIT	(LOCAL_TRCID + 242)
#define TRCID_KIBD_TERM	(LOCAL_TRCID + 243)
#define TRCID_BHC_CACHE_DESTROY	(LOCAL_TRCID + 244)
#define TRCID_KIBD_CACHE_DESTROY	(LOCAL_TRCID + 245)
#define TRCID_KIBDPIN_ENTER	(LOCAL_TRCID + 246)
#define TRCID_KIBDPIN_EXIT	(LOCAL_TRCID + 247)
#define TRCID_KIBD_UNPIN_ALL_ENTER	(LOCAL_TRCID + 248)
#define TRCID_KIBD_UNPIN_ALL_EXIT	(LOCAL_TRCID + 249)
#define TRCID_KIBD_SPLIT	(LOCAL_TRCID + 250)
#define TRCID_KIBD_SPLIT_EXIT	(LOCAL_TRCID + 251)
#define TRCID_KIBD_MERGE	(LOCAL_TRCID + 252)
#define TRCID_KIBD_MERGE_EXIT	(LOCAL_TRCID + 253)
#define TRCID_ATTACH_ENTER	(LOCAL_TRCID + 254)
#define TRCID_ATTACH_KIBD	(LOCAL_TRCID + 255)
#define TRCID_DETACH_KIBD	(LOCAL_TRCID + 256)
#define TRCID_UXFER_LINUX	(LOCAL_TRCID + 257)
#define TRCID_UXFER_UIOMOVE	(LOCAL_TRCID + 258)
#define TRCID_KXFER_LINUX	(LOCAL_TRCID + 259)
#define TRCID_KXFER_MEMCPY	(LOCAL_TRCID + 260)
#define TRCID_KZERO_LINUX	(LOCAL_TRCID + 261)
#define TRCID_KZERO_MEMSET	(LOCAL_TRCID + 262)
#define TRCID_MAP_DISCONTIG_ENTER	(LOCAL_TRCID + 263)
#define TRCID_MAP_DISCONTIG_KMAP	(LOCAL_TRCID + 264)
#define TRCID_UNMAP_DISCONTIG_ENTER	(LOCAL_TRCID + 265)
#define TRCID_UNMAP_DISCONTIG_KUNMAP	(LOCAL_TRCID + 266)
#define TRCID_MAP_CONTIG_ENTER	(LOCAL_TRCID + 267)
#define TRCID_MAP_CONTIG_KMAP	(LOCAL_TRCID + 268)
#define TRCID_MAP_CONTIG_VMALLOC	(LOCAL_TRCID + 269)
#define TRCID_UNMAP_CONTIG_VFREE	(LOCAL_TRCID + 270)
#define TRCID_UNMAP_CONTIG_KUNMAP	(LOCAL_TRCID + 271)
#define TRCID_KDOIO_LINUX	(LOCAL_TRCID + 272)
#define TRCID_KDOIO_LINUX_BH	(LOCAL_TRCID + 273)
#define TRCID_KWAITIO_BH	(LOCAL_TRCID + 274)
#define TRCID_KWAITIO_BH_ERR	(LOCAL_TRCID + 275)
#define TRCID_KWAITIO_BH_BUSY	(LOCAL_TRCID + 276)
#define TRCID_DISKINFO	(LOCAL_TRCID + 277)
#define TRCID_KXREGISTERCLEANUP_EXIT	(LOCAL_TRCID + 278)
#define TRCID_LINUXOPS_TSSTAT_ENTER	(LOCAL_TRCID + 279)
#define TRCID_LINUXOPS_TSSTAT_EXIT	(LOCAL_TRCID + 280)
#define TRCID_LINUXOPS_TSFSTAT_ENTER	(LOCAL_TRCID + 281)
#define TRCID_LINUXOPS_TSFSTAT_EXIT	(LOCAL_TRCID + 282)
#define TRCID_LINUXOPS_TSFATTR_ENTER	(LOCAL_TRCID + 283)
#define TRCID_LINUXOPS_TSFATTR_EXIT	(LOCAL_TRCID + 284)
#define TRCID_LINUXOPS_TSATTR_ENTER	(LOCAL_TRCID + 285)
#define TRCID_LINUXOPS_TSATTR_EXIT	(LOCAL_TRCID + 286)
#define TRCID_LINUXOPS_KXGETACL_EXIT	(LOCAL_TRCID + 287)
#define TRCID_LINUXOPS_KXPUTACL_EXIT	(LOCAL_TRCID + 288)
#define TRCID_LINUXOPS_KXGETDOSATTR_EXIT	(LOCAL_TRCID + 289)
#define TRCID_LINUXOPS_KXPUTDOSATTR_EXIT	(LOCAL_TRCID + 290)
#define TRCID_LINUXOPS_KXNTACCESS_EXIT	(LOCAL_TRCID + 291)
#define TRCID_LINUXOPS_SETSMBOPLOCK_E	(LOCAL_TRCID + 292)
#define TRCID_LINUXOPS_SETSMBOPLOCK_X	(LOCAL_TRCID + 293)
#define TRCID_KXCLAMPLOCKS	(LOCAL_TRCID + 294)
#define TRCID_SS_019	(LOCAL_TRCID + 295)
#define TRCID_SS_023	(LOCAL_TRCID + 296)
#define TRCID_SS_059	(LOCAL_TRCID + 297)
#define TRCID_SS_065	(LOCAL_TRCID + 298)
#define TRCID_SS_075	(LOCAL_TRCID + 299)
#define TRCID_SS_077	(LOCAL_TRCID + 300)
#define TRCID_SS_081	(LOCAL_TRCID + 301)
#define TRCID_SS_083	(LOCAL_TRCID + 302)
#define TRCID_UNPROT_ENTER	(LOCAL_TRCID + 303)
#define TRCID_REPROT_ENTER	(LOCAL_TRCID + 304)
#define TRCID_SHKERN_INIT	(LOCAL_TRCID + 305)
#define TRCID_SHKERN_TERM	(LOCAL_TRCID + 306)
#define TRCID_SSINIT_003	(LOCAL_TRCID + 307)
#define TRCID_CALC_MAX_SHARED	(LOCAL_TRCID + 308)
#define TRCID_ALLOC_SHARED_VMALLOC	(LOCAL_TRCID + 309)
#define TRCID_ALLOC_SHARED_EXIT	(LOCAL_TRCID + 310)
#define TRCID_ALLOC_SHARED_FAIL	(LOCAL_TRCID + 311)
#define TRCID_MAPALL_MULTI	(LOCAL_TRCID + 312)
#define TRCID_FREEALL_VFREE	(LOCAL_TRCID + 313)
#define TRCID_CXI_MAP_PRIVATE	(LOCAL_TRCID + 314)
#define TRCID_MMAP_FLUSH_DIRTY_PAGES_1	(LOCAL_TRCID + 315)
#define TRCID_MMAP_FLUSH_DIRTY_PAGES_2	(LOCAL_TRCID + 316)
#define TRCID_MMAP_FLUSH_DIRTY_PAGES_6	(LOCAL_TRCID + 317)
#define TRCID_MMAP_FLUSH_LOCK_A	(LOCAL_TRCID + 318)
#define TRCID_MMAP_FLUSH_LOCK_B	(LOCAL_TRCID + 319)
#define TRCID_MMAP_FLUSH_UNLOCK_A	(LOCAL_TRCID + 320)
#define TRCID_MMAP_INV_ENTER	(LOCAL_TRCID + 321)
#define TRCID_MMAP_INV_PRESENT	(LOCAL_TRCID + 322)
#define TRCID_MMAP_INV_PTE_NONE	(LOCAL_TRCID + 323)
#define TRCID_MMAP_INVALIDATE_PAGE	(LOCAL_TRCID + 324)
#define TRCID_MMAP_DIRTY_PAGE	(LOCAL_TRCID + 325)
#define TRCID_MMAP_WAIT_ENTER	(LOCAL_TRCID + 326)
#define TRCID_MMAP_WAIT_EXIT	(LOCAL_TRCID + 327)
#define TRCID_MMAP_REG_ENTER	(LOCAL_TRCID + 328)
#define TRCID_MMAP_REG_EXIT	(LOCAL_TRCID + 329)
#define TRCID_MMAP_UNREG_ENTER	(LOCAL_TRCID + 330)
#define TRCID_MMAP_UNREG_EXIT	(LOCAL_TRCID + 331)
#define TRCID_MMAP_CREATE_EXIT	(LOCAL_TRCID + 332)
#define TRCID_MMAP_FILEPOS_ENTER	(LOCAL_TRCID + 333)
#define TRCID_MMAP_RW_ENTER	(LOCAL_TRCID + 334)
#define TRCID_MMAP_RW_EXIT	(LOCAL_TRCID + 335)
#define TRCID_MMAP_IO_ENTER	(LOCAL_TRCID + 336)
#define TRCID_MMAP_IO_EXIT	(LOCAL_TRCID + 337)
#define TRCID_FLUSH_VMA_ENTER	(LOCAL_TRCID + 338)
#define TRCID_FLUSH_VMA_BAD_ADDR	(LOCAL_TRCID + 339)
#define TRCID_PAGE_LOCK	(LOCAL_TRCID + 340)
#define TRCID_FLUSH_VMA_EXIT	(LOCAL_TRCID + 341)
#define TRCID_MMAP_FLUSH_1	(LOCAL_TRCID + 342)
#define TRCID_MMAP_FLUSH_2	(LOCAL_TRCID + 343)
#define TRCID_MMAP_FLUSH_3	(LOCAL_TRCID + 344)
#define TRCID_MMAP_FLUSH_4	(LOCAL_TRCID + 345)
#define TRCID_MMAP_FLUSH_ENTER	(LOCAL_TRCID + 346)
#define TRCID_MMAP_FLUSH_ENTER_A	(LOCAL_TRCID + 347)
#define TRCID_MMAP_FLUSH_INVAL1	(LOCAL_TRCID + 348)
#define TRCID_MMAP_FLUSH_INVAL2	(LOCAL_TRCID + 349)
#define TRCID_MMAP_FLUSH_EXIT	(LOCAL_TRCID + 350)
#define TRCID_DUMP_OPLOCK	(LOCAL_TRCID + 351)
#define TRCID_NLM_SET	(LOCAL_TRCID + 352)
#define TRCID_NLM_RELEASE	(LOCAL_TRCID + 353)
#define TRCID_NLM_EXIT	(LOCAL_TRCID + 354)
#define TRCID_NLM_MOVE	(LOCAL_TRCID + 355)
#define TRCID_NLM_MOVE_EXIT	(LOCAL_TRCID + 356)
#define TRCID_TESTMOVEOPENLOCK	(LOCAL_TRCID + 357)
#define TRCID_TESTMOVERECLOCK	(LOCAL_TRCID + 358)
#define TRCID_TESTCLAMPLOCKS	(LOCAL_TRCID + 359)
#define TRCID_FCNTL_TOKEN	(LOCAL_TRCID + 360)
#define TRCID_FCNTL_SET	(LOCAL_TRCID + 361)
#define TRCID_FCNTL_RELEASE	(LOCAL_TRCID + 362)
#define TRCID_FCNTL_TOKEN_RELEASE	(LOCAL_TRCID + 363)
#define TRCID_FCNTL_FILP	(LOCAL_TRCID + 364)
#define TRCID_FCNTL_OPENMODE_OK	(LOCAL_TRCID + 365)
#define TRCID_FCNTL_OPENMODE_DENIED	(LOCAL_TRCID + 366)
#define TRCID_FCNTL_OPLOCK_SHARED	(LOCAL_TRCID + 367)
#define TRCID_FCNTL_OPLKACK_OK	(LOCAL_TRCID + 368)
#define TRCID_FCNTL_OPLKACK_FAIL	(LOCAL_TRCID + 369)
#define TRCID_FCNTL_STAT	(LOCAL_TRCID + 370)
#define TRCID_OPLOCK_INIT	(LOCAL_TRCID + 371)
#define TRCID_FLUSH_VMA_PGT_LOCK	(LOCAL_TRCID + 372)
#define TRCID_FLUSH_VMA_BAD_PGD	(LOCAL_TRCID + 373)
#define TRCID_FLUSH_VMA_BAD_PMD	(LOCAL_TRCID + 374)
#define TRCID_FLUSH_VMA_BAD_PTE	(LOCAL_TRCID + 375)
#define TRCID_FLUSH_VMA_NONE_PTE	(LOCAL_TRCID + 376)
#define TRCID_FLUSH_VMA_PAGE_LOCK	(LOCAL_TRCID + 377)
#define TRCID_FLUSH_VMA_PGT_UNLOCK	(LOCAL_TRCID + 378)

/* Generated trace calls */

#ifdef __64BIT__

#define TRACE_TRCID_CXIINC_COUNTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXIINC_COUNTER), (Int64)(ibmModule), (Int64)(up));
#define TRACE_TRCID_GPFSINIT_000_CALL \
    _STrace(_HOOKWORD(TRCID_GPFSINIT_000), 1, 0, prog_path, (Int64)(strlen(prog_path)));
#define TRACE_TRCID_PORTINIT_001_CALL \
    _STrace(_HOOKWORD(TRCID_PORTINIT_001), 1, 0, prog_path, (Int64)(trace_level));
#define TRACE_TRCID_FILE_001_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_001), (Int64)(nbytes));
#define TRACE_TRCID_FILE_003_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_003), (Int64)(nbytes));
#define TRACE_TRCID_FILE_005_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FILE_005));
#define TRACE_TRCID_FILE_071_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_071), (Int64)(inode));
#define TRACE_TRCID_FILE_0712_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FILE_0712), (Int64)(bdP), (Int64)(count));
#define TRACE_TRCID_FILE_072_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FILE_072));
#define TRACE_TRCID_BLOCK_005_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BLOCK_005), (Int64)(inode));
#define TRACE_TRCID_BLOCK_0051_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_0051), (Int64)(bdP), (Int64)(count));
#define TRACE_TRCID_BLOCK_071_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BLOCK_071), (Int64)(inode));
#define TRACE_TRCID_BLOCK_0712_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_0712), (Int64)(bdP), (Int64)(count));
#define TRACE_TRCID_BLOCK_072_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_072));
#define TRACE_TRCID_BLOCK_073_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_073));
#define TRACE_TRCID_BLOCK_074_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_074));
#define TRACE_TRCID_BLOCK_011_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_011), (Int64)(GPFSFileSysMajorNumber), (Int64)(rc));
#define TRACE_TRCID_BLOCK_013_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_013), (Int64)(GPFSFileSysMajorNumber), (Int64)(rc));
#define TRACE_TRCID_BLOCK_015_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_015), (Int64)(GPFSFileSysMajorNumber), (Int64)(rc));
#define TRACE_TRCID_INVAL_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_DCACHE), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_INVAL_DUNCACHE_CALL \
    _STrace(_HOOKWORD(TRCID_INVAL_DUNCACHE), 1, 0, dentry->d_name.name, (Int64)(holdCount));
#define TRACE_TRCID_INVAL_DCACHE_NOPRUNE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_DCACHE_NOPRUNE), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_DROP_INVAL_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_DROP_INVAL_DCACHE), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_DROP_DUNCACHE_CALL \
    _STrace(_HOOKWORD(TRCID_DROP_DUNCACHE), 1, 0, dentry->d_name.name, (Int64)(holdCount));
#define TRACE_TRCID_INVAL_NEG_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_NEG_DCACHE), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_DIR_001_CALL \
    _STrace(_HOOKWORD(TRCID_DIR_001), 3, 3, (Int64)(dentry), (Int64)(flags), (Int64)(dentry->d_inode), dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_LLSEEK_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_LLSEEK_ENTER), (Int64)(fP), (Int64)(offset), (Int64)(origin));
#define TRACE_TRCID_LINUXOPS_LLSEEK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_LLSEEK_EXIT), (Int64)(fP), (Int64)(offset), (Int64)(origin));
#define TRACE_TRCID_LINUXOPS_READDIR_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READDIR_ENTER), (Int64)(fP), (Int64)(direntP), (Int64)(filldir), (Int64)(fP->f_pos));
#define TRACE_TRCID_LINUXOPS_READDIR_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_READDIR_EXIT), (Int64)(fP), (Int64)(fP->f_pos), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_POLL_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_POLL), (Int64)(fP));
#define TRACE_TRCID_LINUXOPS_IOCTL_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_IOCTL), (Int64)(iP), (Int64)(fP), (Int64)(cmd));
#define TRACE_TRCID_LINUXOPS_MAP_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_MAP_ENTER), (Int64)(file), (Int64)(inode->i_ino), (Int64)(vma));
#define TRACE_TRCID_LINUXOPS_MAP_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_MAP_EXIT), (Int64)(rc), (Int64)(code));
#define TRACE_TRCID_LINUXOPS_NOPAGE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NOPAGE), (Int64)(area), (Int64)(address), (Int64)(no_share));
#define TRACE_TRCID_LINUXOPS_NOPAGE1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_NOPAGE1), 1, 1, (Int64)(inode->i_ino), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"");
#define TRACE_TRCID_LINUXOPS_NOPAGE_NULL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOPAGE_NULL), (Int64)(area), (Int64)(address));
#define TRACE_TRCID_LINUXOPS_PAGE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_PAGE), (Int64)(pageP), (Int64)(pageP->index), (Int64)(page_count(pageP)), (Int64)(pageP->flags));
#define TRACE_TRCID_FM_OPEN_CALL \
    _STrace(_HOOKWORD(TRCID_FM_OPEN), 3, 3, (Int64)(vma), (Int64)(inode->i_ino), (Int64)(atomic_read((atomic_t *)&inode->i_count)), file->f_dentry? file->f_dentry->d_name.name: (const unsigned char*)"");
#define TRACE_TRCID_FM_OPEN_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FM_OPEN_EXIT), (Int64)(vma), (Int64)(atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_FM_CLOSE_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FM_CLOSE_ENTER), (Int64)(vma), (Int64)(inode), (Int64)((Int32)atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_FM_CLOSE_ENTER1_CALL \
    _STrace(_HOOKWORD(TRCID_FM_CLOSE_ENTER1), 2, 1, (Int64)(inode->i_ino), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"", (Int64)(inode->i_data.nrpages));
#define TRACE_TRCID_FM_CLOSE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FM_CLOSE), (Int64)(vma), (Int64)(inode), (Int64)((Int32)atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER), (Int64)(fP), (Int64)(iP->i_ino), (Int64)(vma));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER_A), (Int64)(vma->vm_start), (Int64)(vma->vm_end), (Int64)(vma->vm_pgoff), (Int64)(vma->vm_flags));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_A1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER_A1), 3, 2, (Int64)(iP->i_ino), (Int64)(atomic_read((atomic_t *)&iP->i_count)), fP->f_dentry ? fP->f_dentry->d_name.name : (const unsigned char*)"", (Int64)(iP->i_data.nrpages));
#define TRACE_TRCID_LINUXOPS_MMAP_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMAP_EXIT), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_OPEN_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_OPEN_ENTER), 6, 4, (Int64)(iP), (Int64)(fP), (Int64)(fP->f_flags), (Int64)(fP->f_dentry), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"", (Int64)(flags), (Int64)(cxiIsNFSThread()));
#define TRACE_TRCID_LINUXOPS_OPEN_01_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_OPEN_01), (Int64)(iP), (Int64)(cnP), (Int64)(fflags), (Int64)(amode));
#define TRACE_TRCID_LINUXOPS_OPEN_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_OPEN_EXIT), (Int64)(iP), (Int64)((struct MMFSVInfo *)fP->private_data), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_CLOSE_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_CLOSE_ENTER), (Int64)(iP), (Int64)(fP->f_flags), (Int64)(flags), (Int64)(vinfoP));
#define TRACE_TRCID_CLOSE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CLOSE_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_FSYNC_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_FSYNC_ENTER), (Int64)(fP), (Int64)(direntP), (Int64)(datasync));
#define TRACE_TRCID_LINUXOPS_FSYNC_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FSYNC_EXIT), (Int64)(fP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_FASYNC_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_FASYNC_ENTER), (Int64)(fd), (Int64)(fP), (Int64)(on));
#define TRACE_TRCID_LINUXOPS_FASYNC_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FASYNC_EXIT), (Int64)(fP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_MEDIA_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MEDIA), (Int64)(dev));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_DEV_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_DEV), (Int64)(dev));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER_CALL \
    _XTrace(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER), "gpfs_f_lock enter: pid %d fp 0x%X range 0x%lX:%lX cmd %s type %s\n", (Int64)(flP->fl_pid), (Int64)(fP), (Int64)(flP->fl_start), (Int64)(flP->fl_end), (cmd == F_GETLK) ? "GETLK" : (cmd == F_SETLK) ? "SETLK" : "SETLKW", (flP->fl_type == F_RDLCK) ? "RDLCK" :          (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER2_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER2), (Int64)(fP->f_pos), (Int64)(fP->f_dentry->d_inode), (Int64)(flP->fl_flags), (Int64)(eCred.principal), (Int64)(eCred.group));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER3_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER3), (Int64)(nodenumber));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_DIAG2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_DIAG2), (Int64)(fP), (Int64)(fP->f_dentry));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_EXIT), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_RDWRINT_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RDWRINT_ENTER), 10, 10, (Int64)(fP), (Int64)(fP->f_flags), (Int64)(flags), (Int64)(op), (Int64)(iovecP), (Int64)(count), (Int64)(*offsetP), (Int64)(fP->f_dentry), (Int64)(fP->private_data), (Int64)(fP->f_dentry->d_inode), fP->f_dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_RDWRINT_EXIT_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_RDWRINT_EXIT), (Int64)(fP), (Int64)(total_len), (Int64)(tmp_uio.uio_resid), (Int64)(tmp_uio.uio_offset), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_READ_DIR_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READ_DIR), (Int64)(fP));
#define TRACE_TRCID_PRINTINODE_1_CALL \
    _TRACE7D(_HOOKWORD(TRCID_PRINTINODE_1), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(iP->i_ino), (Int64)(atomic_read((atomic_t *)&iP->i_count)), (Int64)(iP->i_dev), (Int64)(iP->i_mode), (Int64)(iP->i_nlink));
#define TRACE_TRCID_PRINTINODE_2_CALL \
    _TRACE6D(_HOOKWORD(TRCID_PRINTINODE_2), (Int64)(iP->i_uid), (Int64)(iP->i_gid), (Int64)(iP->i_rdev), (Int64)(iP->i_size), (Int64)(iP->i_atime), (Int64)(iP->i_mtime));
#define TRACE_TRCID_PRINTINODE_3_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTINODE_3), (Int64)(iP->i_ctime), (Int64)(iP->i_blksize), (Int64)(iP->i_blocks), (Int64)(iP->i_version), (Int64)(iP->i_op));
#define TRACE_TRCID_PRINTINODE_4_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTINODE_4), (Int64)(iP->i_fop), (Int64)(iP->i_sb), (Int64)(iP->i_attr_flags), (Int64)(iP->i_generation), (Int64)(iP->u.generic_ip));
#define TRACE_TRCID_PRINTINODE_5_CALL \
    _TRACE6D(_HOOKWORD(TRCID_PRINTINODE_5), (Int64)(&(iP->i_hash)), (Int64)(iP->i_hash.next), (Int64)(iP->i_hash.prev), (Int64)(&(iP->i_list)), (Int64)(iP->i_list.next), (Int64)(iP->i_list.prev));
#define TRACE_TRCID_PRINTDENTRY_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PRINTDENTRY_1), (Int64)(dP), (Int64)(atomic_read((atomic_t *)&dP->d_count)), (Int64)(dP->d_flags), (Int64)(dP->d_inode));
#define TRACE_TRCID_PRINTDENTRY_2a_CALL \
    _TRACE2D(_HOOKWORD(TRCID_PRINTDENTRY_2a), (Int64)(dP->d_parent), (Int64)(dP->d_hash.next));
#define TRACE_TRCID_PRINTDENTRY_2_CALL \
    _TRACE3D(_HOOKWORD(TRCID_PRINTDENTRY_2), (Int64)(dP->d_parent), (Int64)(dP->d_vfsmnt.next), (Int64)(dP->d_hash.next));
#define TRACE_TRCID_PRINTDENTRY_3_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PRINTDENTRY_3), (Int64)(dP->d_lru.next), (Int64)(dP->d_child.next), (Int64)(dP->d_subdirs.next), (Int64)(dP->d_alias.next));
#define TRACE_TRCID_PRINTDENTRY_4a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTDENTRY_4a), (Int64)(dP->d_time), (Int64)(dP->d_op), (Int64)(dP->d_sb), (Int64)(dP->d_vfs_flags), (Int64)(dP->d_name.name));
#define TRACE_TRCID_PRINTDENTRY_4_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTDENTRY_4), (Int64)(dP->d_time), (Int64)(dP->d_op), (Int64)(dP->d_sb), (Int64)(dP->d_reftime), (Int64)(dP->d_name.name));
#define TRACE_TRCID_PRINTDENTRY_5_CALL \
    _STrace(_HOOKWORD(TRCID_PRINTDENTRY_5), 1, 1, (Int64)(dP->d_fsdata), dP->d_iname);
#define TRACE_TRCID_LINUXOPS_SETINODE_CALL \
    _TRACE7D(_HOOKWORD(TRCID_LINUXOPS_SETINODE), (Int64)(inodeP), (Int64)(inodeP->i_ino), (Int64)(atomic_read((atomic_t *)&inodeP->i_count)), (Int64)(inodeP->i_mode), (Int64)(attrP->va_xinfo), (Int64)(inodeP->i_nlink), (Int64)(inodeP->i_size));
#define TRACE_TRCID_CXIINVA_PERM_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXIINVA_PERM), (Int64)(cnP), (Int64)(inodeP->i_op == &gpfs_iops_stdperm), (Int64)(inodeP->i_op == &gpfs_dir_iops_stdperm));
#define TRACE_TRCID_LINUXOPS_CREATE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_CREATE_ENTER), 3, 3, (Int64)(diP), (Int64)(dentryP), (Int64)(mode), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_CREATE_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_CREATE_EXIT), (Int64)(newInodeP), (Int64)(iNum), (Int64)(iNum), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_LOOKUP_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_ENTER), 2, 2, (Int64)(diP), (Int64)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_LOOKUP_STALE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_STALE), (Int64)(diP), (Int64)(diP->i_ino));
#define TRACE_TRCID_LINUXOPS_LOOKUP_EXIT_CALL \
    _TRACE7D(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_EXIT), (Int64)(newInodeP), (Int64)(iNum), (Int64)(iNum), (Int64)(cnP), (Int64)(retP), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_LINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_LINK_ENTER), 3, 3, (Int64)(diP), (Int64)(oldDentryP), (Int64)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_LINK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_LINK_EXIT), (Int64)(diP), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_UNLINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_UNLINK_ENTER), 3, 3, (Int64)(diP), (Int64)(iP), (Int64)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_UNLINK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_UNLINK_EXIT), (Int64)(diP), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_SYMLINK1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_SYMLINK1), 2, 2, (Int64)(diP), (Int64)(dentryP), symlinkTargetP);
#define TRACE_TRCID_LINUXOPS_SYMLINK2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_SYMLINK2), 0, 0, dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_SYMLINK_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_SYMLINK_EXIT), (Int64)(newInodeP), (Int64)(iNum), (Int64)(iNum), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_MKDIR_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MKDIR_ENTER), 2, 2, (Int64)(diP), (Int64)(mode), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_MKDIR_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MKDIR_EXIT), (Int64)(newInodeP), (Int64)(iNum), (Int64)(iNum), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_RMDIR_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RMDIR_ENTER), 2, 2, (Int64)(diP), (Int64)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RMDIR_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_RMDIR_EXIT), (Int64)(diP), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_MKNOD_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MKNOD_ENTER), 3, 3, (Int64)(diP), (Int64)(mode), (Int64)(rdev), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_MKNOD_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MKNOD_EXIT), (Int64)(newInodeP), (Int64)(iNum), (Int64)(iNum), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_RENAME_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RENAME_1), 2, 2, (Int64)(iP), (Int64)(diP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RENAME_2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RENAME_2), 2, 2, (Int64)(tiP), (Int64)(tdiP), tDentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RENAME_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_RENAME_EXIT), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_READLINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READLINK_ENTER), 4, 4, (Int64)(dentryP), (Int64)(bufP), (Int64)(buflen), (Int64)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_READLINK_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READLINK_EXIT), (Int64)(iP), (Int64)(tmpUio.uio_resid), (Int64)(tmpUio.uio_offset), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_ENTER), 1, 1, (Int64)(dentry->d_inode), dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_1), 1, 1, (Int64)(rc), buf);
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_2), (Int64)(dentry->d_inode), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_READPAGE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READPAGE_ENTER), 3, 3, (Int64)(dentryP), (Int64)(pageP), (Int64)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_READPAGE_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READPAGE_ENTER_A), (Int64)(pageP), (Int64)(pageP->index), (Int64)(page_count(pageP)), (Int64)(pageP->flags));
#define TRACE_TRCID_LINUXOPS_READPAGE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READPAGE_EXIT), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_WRPAGE_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_ENTER), (Int64)(pageP), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_LINUXOPS_WRPAGE_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_ENTER_A), (Int64)(pageP), (Int64)(pageP->index), (Int64)(page_count(pageP)), (Int64)(pageP->flags));
#define TRACE_TRCID_LINUXOPS_WRPAGE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_EXIT), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_TRUNCATE_PAGE_ENTER_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_TRUNCATE_PAGE_ENTER), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(atomic_read((atomic_t *)&iP->i_count)), (Int64)(pageP), (Int64)(page_count(pageP)));
#define TRACE_TRCID_LINUXOPS_BMAP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_BMAP));
#define TRACE_TRCID_LINUXOPS_TRUNCATE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_TRUNCATE), (Int64)(iP));
#define TRACE_TRCID_LINUXOPS_ACCESS_ENTER_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_ACCESS_ENTER), (Int64)(iP), (Int64)(mode), (Int64)(current->fsuid), (Int64)(current->fsgid), (Int64)(iP->i_mode), (Int64)(cnP->xinfo));
#define TRACE_TRCID_LINUXOPS_ACCESS_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_ACCESS_EXIT), (Int64)(iP), (Int64)(iP->i_op == &gpfs_iops_stdperm), (Int64)(iP->i_op == &gpfs_dir_iops_stdperm), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_SMAP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_SMAP));
#define TRACE_TRCID_LINUXOPS_UPDATEPAGE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_UPDATEPAGE));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_ENTER), 3, 3, (Int64)(dentryP), (Int64)(dentryP->d_inode), (Int64)((iP) ? iP->i_ino : -1), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_REVALIDATE_STALE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_STALE), (Int64)(iP), (Int64)(iP->i_ino));
#define TRACE_TRCID_REVAL_DELAY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_REVAL_DELAY), (Int64)(howLong));
#define TRACE_TRCID_REVAL_DELAY_END_CALL \
    _TRACE1D(_HOOKWORD(TRCID_REVAL_DELAY_END), (Int64)(howLong));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_EXIT), (Int64)(dentryP), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_SETATTR_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_SETATTR_ENTER), (Int64)(iP), (Int64)(aP->ia_valid), (Int64)(aP->ia_attr_flags));
#define TRACE_TRCID_LINUXOPS_SETATTR_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_SETATTR_EXIT), (Int64)(iP), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_GETATTR_ENTER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_GETATTR_ENTER), (Int64)(iP));
#define TRACE_TRCID_LINUXOPS_GETATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_GETATTR_EXIT), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_VNODE_BKL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_VNODE_BKL), (Int64)(kernel_locked()), (Int64)(current->lock_depth));
#define TRACE_TRCID_LINUXOPS_READINODE_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READINODE_ENTER), (Int64)(iP), (Int64)(inum));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_1), (Int64)(iP), (Int64)(cnP), (Int64)(sizeof(iP->u) - sizeof(void *)), (Int64)(CXINODE_SIZE));
#define TRACE_TRCID_LINUXOPS_READINODE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READINODE_EXIT), (Int64)(iP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_READINODE_HUH_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_READINODE_HUH));
#define TRACE_TRCID_LINUXOPS_DELETE_INODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_DELETE_INODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(isGPFS));
#define TRACE_TRCID_LINUXOPS_DELETE_INODE_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_DELETE_INODE_1), (Int64)(iP), (Int64)(cnP));
#define TRACE_TRCID_LINUXOPS_NOTIFY_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOTIFY_ENTER), (Int64)(dentryP->d_inode), (Int64)(attrP));
#define TRACE_TRCID_LINUXOPS_NOTIFY_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOTIFY_EXIT), (Int64)(dentryP->d_inode), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_PUTSUPER_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_PUTSUPER_ENTER), (Int64)(sbP), (Int64)(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_PUTSUPER_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_PUTSUPER_EXIT), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_STATFS_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_STATFS_ENTER), (Int64)(sbP), (Int64)(len));
#define TRACE_TRCID_LINUXOPS_STATFS_EXIT_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_STATFS_EXIT), (Int64)(bufP->f_blocks), (Int64)(bufP->f_bfree), (Int64)(bufP->f_files), (Int64)(bufP->f_ffree), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_UMOUNT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_UMOUNT_ENTER), (Int64)(sbP), (Int64)(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_UMOUNT_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UMOUNT_EXIT), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_REMOUNT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_REMOUNT));
#define TRACE_TRCID_LINUXOPS_WRITEINODE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_WRITEINODE));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(iP->u.generic_ip));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_DETAILS_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE_DETAILS), (Int64)(VP_TO_CNP(iP)), (Int64)(VP_TO_PVP(iP)), (Int64)(NODE_TOO_BIG_FOR_OSNODE(CXINODE_SIZE)));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE_EXIT), (Int64)(iP), (Int64)(iP->u.generic_ip), (Int64)(code));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER), (Int64)(sbP));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_3_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER_3));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_5_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER_5), (Int64)(sbP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_READSUPER_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_1), 3, 3, (Int64)(sbP), (Int64)(sbP->s_dev), (Int64)(silent), ((char *)dataP == NULL) ? "" : dataP);
#define TRACE_TRCID_LINUXOPS_READSUPER_2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_2), 0, 0, bdevname(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_READSUPER_STARTHELPER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_STARTHELPER), 0, 0, mmfs_path);
#define TRACE_TRCID_LINUXOPS_READSUPER_HELPERRC_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_HELPERRC), (Int64)(mountHelperID));
#define TRACE_TRCID_LINUXOPS_READSUPER_SUCCEED_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_SUCCEED), (Int64)(sbP));
#define TRACE_TRCID_LINUXOPS_READSUPER_FAILED_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_FAILED), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_REGFS_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_REGFS), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_UNREGFS_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UNREGFS), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_1), (Int64)(inode), (Int64)(filp), (Int64)(current->pid), (Int64)(inode->u.generic_ip));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_2_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_2), (Int64)(mmfsd_id));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_3_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_3), (Int64)(mount_id));
#define TRACE_TRCID_LINUXOPS_KILLMMFSD_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_KILLMMFSD), (Int64)(mmfsd_id));
#define TRACE_TRCID_SWAPD_CLEARINODE_CALL \
    _TRACE5D_NB(_HOOKWORD(TRCID_SWAPD_CLEARINODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(unusedInodeP), (Int64)(unusedSuperP), (Int64)(unusedInodeNum));
#define TRACE_TRCID_SWAPD_READINODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_SWAPD_READINODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(unusedInodeP), (Int64)(unusedSuperP), (Int64)(unusedInodeNum));
#define TRACE_TRCID_ADDOSNODE_UNUSED_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ADDOSNODE_UNUSED), (Int64)(iP), (Int64)(sbP), (Int64)(unusedInodeNum), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_EXECMMFS_1_CALL \
    _XTrace(_HOOKWORD(TRCID_LINUXOPS_EXECMMFS_1), "exec_mmfs: mmfs_path %s mount_opt %s\n", mmfs_path, mount_opt);
#define TRACE_TRCID_LINUXOPS_EXECMMFS_EXIT_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_EXECMMFS_EXIT), 3, 3, (Int64)(rc), (Int64)(code), (Int64)(errno), mmfs_path);
#define TRACE_TRCID_LINUXOPS_FORK_MOUNTHELPER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_FORK_MOUNTHELPER), (Int64)(mount_id));
#define TRACE_TRCID_SET_MOUNT_INFO_CALL \
    _TRACE4D(_HOOKWORD(TRCID_SET_MOUNT_INFO), (Int64)(sbP), (Int64)(rootIP), (Int64)(cnRootP), (Int64)(gnRootP));
#define TRACE_TRCID_LINUXOPS_UNMOUNTINT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_UNMOUNTINT_ENTER), (Int64)(sbP), (Int64)(force));
#define TRACE_TRCID_LINUXOPS_UNMOUNTINT_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UNMOUNTINT_EXIT), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_REACTIVATE_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REACTIVATE_VNODE), (Int64)(osVfsP), (Int64)(cnP), (Int64)(osNodePP));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE), (Int64)(sbP), (Int64)(inum), (Int64)(nodeSize));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_EXIT), (Int64)(*osNodePP), (Int64)(*cnPP), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_BAD_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_BAD), (Int64)(nodeSize), (Int64)(CXINODE_SIZE));
#define TRACE_TRCID_LINUXOPS_DELETE_VNODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_DELETE_VNODE), (Int64)(sbP), (Int64)(cnP), (Int64)(iP), (Int64)(iP ? iP->i_ino : -1), (Int64)(iP ? atomic_read((atomic_t *)&iP->i_count) : 0));
#define TRACE_TRCID_LINUXOPS_DELETE_MMAP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_DELETE_MMAP), (Int64)(segid));
#define TRACE_TRCID_LINUXOPS_REINIT_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REINIT_VNODE), (Int64)(sbP), (Int64)(cnP), (Int64)(iP));
#define TRACE_TRCID_LINUXOPS_FIND_VNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_FIND_VNODE), (Int64)(sbP), (Int64)(cnP), (Int64)(*osNodePP), (Int64)(iP ? atomic_read((atomic_t *)&iP->i_count) : 0), (Int64)(holdit), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_DUMP_VNODE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_DUMP_VNODE), (Int64)(cnP), (Int64)(iP));
#define TRACE_TRCID_LINUXOPS_REF_VNODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_REF_VNODE), (Int64)(osVfsP), (Int64)(cnP), (Int64)(iP), (Int64)(ino), (Int64)(holdCount));
#define TRACE_TRCID_LINUXOPS_INACTIVE_VNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_INACTIVE_VNODE), (Int64)(sbP), (Int64)(cnP), (Int64)(iP), (Int64)(holdCount), (Int64)(*canCacheP), (Int64)(*hasReferencesP));
#define TRACE_TRCID_LINUXOPS_PUT_OSNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_PUT_OSNODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(holdCount-1));
#define TRACE_TRCID_LINUXOPS_DESTROY_OSNODE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_DESTROY_OSNODE), (Int64)(iP), (Int64)(iP->i_ino), (Int64)(holdCount), (Int64)(iP->i_nlink));
#define TRACE_TRCID_CXIUPDATE_INODE_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_CXIUPDATE_INODE_2), (Int64)(iP), (Int64)(iP->i_atime), (Int64)(iP->i_mtime), (Int64)(iP->i_ctime));
#define TRACE_TRCID_CXIUPDATE_INODE_1_CALL \
    _TRACE7D(_HOOKWORD(TRCID_CXIUPDATE_INODE_1), (Int64)(what), (Int64)(iP->i_mode), (Int64)(iP->i_uid), (Int64)(iP->i_gid), (Int64)(iP->i_nlink), (Int64)(iP->i_size), (Int64)(iP->i_blocks));
#define TRACE_TRCID_LINUXOPS_CANUNCACHE_OSNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_CANUNCACHE_OSNODE), (Int64)(cnP), (Int64)(vP), (Int64)(osVfsP), (Int64)((iP ? iP->i_sb : 0)), (Int64)((iP ? iP->i_ino : 0)), (Int64)(count));
#define TRACE_TRCID_LINUXOPS_ADD_OSNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_ADD_OSNODE), (Int64)(dentryP), (Int64)(vP), (Int64)(d_unhashed(dP)));
#define TRACE_TRCID_FCNTLLOCK_ENTER_CALL \
    _XTrace(_HOOKWORD(TRCID_FCNTLLOCK_ENTER), "cxiFcntlLock posix_lock_file: pid %d owner 0x%X inodeP 0x%X "          "range 0x%lX-%lX cmd %s type %s\n", (Int64)(flP->fl_pid), (Int64)(flP->fl_owner), (Int64)(advObjP), (Int64)(flP->fl_start), (Int64)(flP->fl_end), (cmd == F_GETLK) ? "GETLK" : (cmd == F_SETLK) ? "SETLK" : "SETLKW", (flP->fl_type == F_RDLCK) ? "RDLCK" :          (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_FCNTLLOCK_GETLK_CALL \
    _STrace(_HOOKWORD(TRCID_FCNTLLOCK_GETLK), 5, 5, (Int64)(flP->fl_pid), (Int64)(flP->fl_owner), (Int64)(advObjP), (Int64)(flP->fl_start), (Int64)(flP->fl_end), (flP->fl_type == F_RDLCK) ? "RDLCK" :            (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_FCNTLLOCK_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTLLOCK_EXIT), (Int64)(rc), (Int64)(cflP));
#define TRACE_TRCID_SLEEP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SLEEP), (Int64)(ms));
#define TRACE_TRCID_SLEEP_END_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SLEEP_END), (Int64)(ms), (Int64)(HZ));
#define TRACE_TRCID_OPENNFS_CALL \
    _TRACE7D(_HOOKWORD(TRCID_OPENNFS), (Int64)(inodeP), (Int64)((inodeP) ? inodeP->i_ino : -1), (Int64)((inodeP) ? inodeP->i_ino : -1), (Int64)((inodeP) ? inodeP->i_mode : -1), (Int64)((inodeP) ? inodeP->i_nlink : -1), (Int64)((inodeP) ? inodeP->u.generic_ip : NULL), (Int64)(refcount));
#define TRACE_TRCID_CXISTART_KPROC_LINUX_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTART_KPROC_LINUX), 1, 0, kpdP->nameP, (Int64)(kpdP->pid));
#define TRACE_TRCID_CXISTOP_KPROC_LINUX_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTOP_KPROC_LINUX), 1, 0, kpdP->nameP, (Int64)(kpdP->pid));
#define TRACE_TRCID_CXISTOP_KPROC_STILL_ALIVE_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTOP_KPROC_STILL_ALIVE), 1, 0, kpdP->nameP, (Int64)(pid));
#define TRACE_TRCID_PANIC_CALL \
    _STrace(_HOOKWORD(TRCID_PANIC), 0, 0, panicStrP);
#define TRACE_TRCID_MODULE_LOGASSERT_1_CALL \
    _STrace(_HOOKWORD(TRCID_MODULE_LOGASSERT_1), 2, 0, failingExpr, (Int64)(retCode), (Int64)(reasonCode));
#define TRACE_TRCID_MODULE_LOGASSERT_2_CALL \
    _STrace(_HOOKWORD(TRCID_MODULE_LOGASSERT_2), 1, 0, srcFileName, (Int64)(srcLineNumber));
#define TRACE_TRCID_CXISYSTEM_001_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_001), (Int64)(lockP->slCount), (Int64)(lockP->slState), (Int64)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_003_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_003), (Int64)(lockP->slCount), (Int64)(lockP->slState), (Int64)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SUNLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SUNLOCK), (Int64)(lockP->slCount), (Int64)(lockP->slState), (Int64)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SUNLOCK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SUNLOCK_EXIT), (Int64)(lockP->slCount), (Int64)(lockP->slState), (Int64)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SLEEP_THREAD_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SLEEP_THREAD_ENTER), (Int64)(weP), (Int64)(sl), (Int64)(waitFlags));
#define TRACE_TRCID_CXISYSTEM_SLEEP_THREAD_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SLEEP_THREAD_EXIT), (Int64)(weP), (Int64)(sl), (Int64)(waitElement.wakeupRC));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP), (Int64)(weP));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_ONE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP_ONE), (Int64)(weP));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_RESULT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP_RESULT), (Int64)(weP), (Int64)(rc));
#define TRACE_TRCID_CXISYSTEM_037_CALL \
    _TRACE4D(_HOOKWORD(TRCID_CXISYSTEM_037), (Int64)(kBufP), (Int64)(uioP), (Int64)(nBytes), (Int64)(toKernel));
#define TRACE_TRCID_CXISYSTEM_039a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXISYSTEM_039a), (Int64)(rc), (Int64)(trcdata[0]), (Int64)(trcdata[1]), (Int64)(trcdata[2]), (Int64)(trcdata[3]));
#define TRACE_TRCID_CXISYSTEM_039_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_039), (Int64)(rc));
#define TRACE_TRCID_CXISYSTEM_041a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXISYSTEM_041a), (Int64)(rc), (Int64)(trcdata[0]), (Int64)(trcdata[1]), (Int64)(trcdata[2]), (Int64)(trcdata[3]));
#define TRACE_TRCID_CXISYSTEM_041_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_041), (Int64)(rc));
#define TRACE_TRCID_CXISYSTEM_CHKTYPES_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_CHKTYPES), (Int64)(rc));
#define TRACE_TRCID_BM_INIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_INIT), (Int64)(mP), (Int64)(bmNameIdx));
#define TRACE_TRCID_BM_ACQ_CALL \
    _TRACE4D(_HOOKWORD(TRCID_BM_ACQ), (Int64)(mP), (Int64)(mP->lockNameIndex), (Int64)(current), (Int64)(currentOwner));
#define TRACE_TRCID_BM_ACQ_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BM_ACQ_EXIT), (Int64)(mP));
#define TRACE_TRCID_BM_REL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_REL), (Int64)(mP), (Int64)(mP->lockNameIndex));
#define TRACE_TRCID_BM_TERM_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_TERM), (Int64)(mP), (Int64)(mP->lockNameIndex));
#define TRACE_TRCID_CXISYSTEM_017_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_017), (Int64)(ownerP), (Int64)(result));
#define TRACE_TRCID_CXISYSTEM_018_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_018), (Int64)(mP), (Int64)(result));
#define TRACE_TRCID_CXISYSTEM_EVENT_WAIT_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_EVENT_WAIT_ENTER), (Int64)(weP), (Int64)(waitFlags), (Int64)(mutexP));
#define TRACE_TRCID_CXISYSTEM_EVENT_WAIT_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_EVENT_WAIT_EXIT), (Int64)(weP), (Int64)(mutexP), (Int64)(waitElement.wakeupRC));
#define TRACE_TRCID_CXISYSTEM_SIGNAL_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_SIGNAL), (Int64)(weP));
#define TRACE_TRCID_CXISYSTEM_BROADCAST_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_BROADCAST), (Int64)(weP));
#define TRACE_TRCID_CXISYSTEM_BROADCAST_RC_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_BROADCAST_RC), (Int64)(weP), (Int64)(rc));
#define TRACE_TRCID_SMBOPENLOCKCONTROL_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SMBOPENLOCKCONTROL_1), (Int64)(command), (Int64)(lockmode));
#define TRACE_TRCID_SMBOPENLOCKCONTROL_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SMBOPENLOCKCONTROL_EXIT), (Int64)(rc));
#define TRACE_TRCID_SMBOPENLOCKMOVE_1_CALL \
    _TRACE3D(_HOOKWORD(TRCID_SMBOPENLOCKMOVE_1), (Int64)(command), (Int64)(lockmode), (Int64)(nodenumber));
#define TRACE_TRCID_SMBOPENLOCKMOVE_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SMBOPENLOCKMOVE_EXIT), (Int64)(rc));
#define TRACE_TRCID_CXICHECKOPEN_ENTRY_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXICHECKOPEN_ENTRY), (Int64)(count), (Int64)(inodeP->i_ino), (Int64)(inodeP));
#define TRACE_TRCID_CXICHECKOPEN_FOUND_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXICHECKOPEN_FOUND), (Int64)(fileP->private_data));
#define TRACE_TRCID_KIBD_NEW_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_NEW), (Int64)(kibdP));
#define TRACE_TRCID_KIBD_DELETE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_DELETE), (Int64)(kibdP));
#define TRACE_TRCID_DEALLOC_KIBD_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_DEALLOC_KIBD_1), (Int64)(kibdPrevP), (Int64)(kibdPrevP->kibdVaddr), (Int64)(kibdPrevP->kibdPages), (Int64)(kibdP));
#define TRACE_TRCID_DEALLOC_KIBD_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_DEALLOC_KIBD_2), (Int64)(kibdPrevP), (Int64)(kibdPrevP->kibdVaddr), (Int64)(kibdPrevP->kibdPages), (Int64)(kibdP));
#define TRACE_TRCID_ALLOC_KIBD_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_1), (Int64)(kibdPrevP), (Int64)(kibdPrevP->kibdVaddr), (Int64)(kibdPrevP->kibdPages), (Int64)(kibdP));
#define TRACE_TRCID_ALLOC_KIBD_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_2), (Int64)(kibdP), (Int64)(kibdP->kibdVaddr), (Int64)(kibdP->kibdPages), (Int64)(totalPages));
#define TRACE_TRCID_ALLOC_KIBD_UNCACHE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_UNCACHE), (Int64)(kibdHeadP), (Int64)(pageP), (Int64)(atomic_read(&pageP->count)), (Int64)(addrSpaceP));
#define TRACE_TRCID_KIBD_INIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_INIT));
#define TRACE_TRCID_KIBD_TERM_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_TERM));
#define TRACE_TRCID_BHC_CACHE_DESTROY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BHC_CACHE_DESTROY), (Int64)(rc));
#define TRACE_TRCID_KIBD_CACHE_DESTROY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_CACHE_DESTROY), (Int64)(rc));
#define TRACE_TRCID_KIBDPIN_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KIBDPIN_ENTER), (Int64)(vaddr), (Int64)(len));
#define TRACE_TRCID_KIBDPIN_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBDPIN_EXIT), (Int64)(headP));
#define TRACE_TRCID_KIBD_UNPIN_ALL_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_UNPIN_ALL_ENTER));
#define TRACE_TRCID_KIBD_UNPIN_ALL_EXIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_UNPIN_ALL_EXIT));
#define TRACE_TRCID_KIBD_SPLIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KIBD_SPLIT), (Int64)(kibdP), (Int64)(vaddr), (Int64)(nPages), (Int64)(frontPages));
#define TRACE_TRCID_KIBD_SPLIT_EXIT_CALL \
    _TRACE5D(_HOOKWORD(TRCID_KIBD_SPLIT_EXIT), (Int64)(frontP), (Int64)(frontPages), (Int64)(rearP), (Int64)(nPages-frontPages), (Int64)(rc));
#define TRACE_TRCID_KIBD_MERGE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KIBD_MERGE), (Int64)(frontP), (Int64)(vaddr), (Int64)(nPages), (Int64)(rearP), (Int64)(rearP->kibdVaddr), (Int64)(rearP->kibdTotalPages));
#define TRACE_TRCID_KIBD_MERGE_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KIBD_MERGE_EXIT), (Int64)(mergedP), (Int64)(vaddr), (Int64)(nPages), (Int64)(rc));
#define TRACE_TRCID_ATTACH_ENTER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_ATTACH_ENTER), (Int64)(OffsetToDataPtr(iobP,0,0)));
#define TRACE_TRCID_ATTACH_KIBD_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ATTACH_KIBD), (Int64)(iobP->kernelIOBufferDescP), (Int64)(newPinCount));
#define TRACE_TRCID_DETACH_KIBD_CALL \
    _TRACE3D(_HOOKWORD(TRCID_DETACH_KIBD), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(attachP->kDescP), (Int64)(iobP->pinCount));
#define TRACE_TRCID_UXFER_LINUX_CALL \
    _TRACE5D(_HOOKWORD(TRCID_UXFER_LINUX), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(kibdP), (Int64)(toIOBuffer), (Int64)(bufOffset), (Int64)(len));
#define TRACE_TRCID_UXFER_UIOMOVE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_UXFER_UIOMOVE), (Int64)(pageIndex), (Int64)(kaddr), (Int64)(pageOffset), (Int64)(pageLen));
#define TRACE_TRCID_KXFER_LINUX_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KXFER_LINUX), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(kibdP), (Int64)(toIOBuffer), (Int64)(bufOffset), (Int64)(len), (Int64)(kBufP));
#define TRACE_TRCID_KXFER_MEMCPY_CALL \
    _TRACE5D(_HOOKWORD(TRCID_KXFER_MEMCPY), (Int64)(kibdP), (Int64)(pageIndex), (Int64)(kaddr), (Int64)(pageOffset), (Int64)(pageLen));
#define TRACE_TRCID_KZERO_LINUX_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KZERO_LINUX), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(kibdP), (Int64)(bufOffset), (Int64)(len));
#define TRACE_TRCID_KZERO_MEMSET_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KZERO_MEMSET), (Int64)(pageIndex), (Int64)(kaddr), (Int64)(pageOffset), (Int64)(pageLen));
#define TRACE_TRCID_MAP_DISCONTIG_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MAP_DISCONTIG_ENTER), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(kibdP), (Int64)(iobP->ioBufLen));
#define TRACE_TRCID_MAP_DISCONTIG_KMAP_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MAP_DISCONTIG_KMAP), (Int64)(pageIndex), (Int64)(kibdP), (Int64)(pageP), (Int64)(kaddr));
#define TRACE_TRCID_UNMAP_DISCONTIG_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_UNMAP_DISCONTIG_ENTER), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(iobP->kernelIOBufferDescP), (Int64)(iobP->ioBufLen), (Int64)(discontigP->mappedLen));
#define TRACE_TRCID_UNMAP_DISCONTIG_KUNMAP_CALL \
    _TRACE3D(_HOOKWORD(TRCID_UNMAP_DISCONTIG_KUNMAP), (Int64)(pageIndex), (Int64)(pageP), (Int64)(discontigP->userPagePointerArray[pageIndex]));
#define TRACE_TRCID_MAP_CONTIG_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MAP_CONTIG_ENTER), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(kibdP), (Int64)(bufOffset), (Int64)(len));
#define TRACE_TRCID_MAP_CONTIG_KMAP_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MAP_CONTIG_KMAP), (Int64)(pageP), (Int64)(*contigBasePP));
#define TRACE_TRCID_MAP_CONTIG_VMALLOC_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MAP_CONTIG_VMALLOC), (Int64)(tempBufP));
#define TRACE_TRCID_UNMAP_CONTIG_VFREE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_UNMAP_CONTIG_VFREE), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(contigP->mallocedBaseP));
#define TRACE_TRCID_UNMAP_CONTIG_KUNMAP_CALL \
    _TRACE2D(_HOOKWORD(TRCID_UNMAP_CONTIG_KUNMAP), (Int64)(OffsetToDataPtr(iobP,0,0)), (Int64)(contigP->pageP));
#define TRACE_TRCID_KDOIO_LINUX_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KDOIO_LINUX), (Int64)(kibdP), (Int64)(isWrite), (Int64)(dev), (Int64)(startSector), (Int64)(nSectors), (Int64)(bufOffset));
#define TRACE_TRCID_KDOIO_LINUX_BH_CALL \
    _TRACE3D(_HOOKWORD(TRCID_KDOIO_LINUX_BH), (Int64)(bhP), (Int64)(startSector), (Int64)(sectorsThisBH));
#define TRACE_TRCID_KWAITIO_BH_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KWAITIO_BH), (Int64)(bhP), (Int64)(bhP->b_rsector), (Int64)(bhP->b_size), (Int64)(bhP->b_state));
#define TRACE_TRCID_KWAITIO_BH_ERR_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KWAITIO_BH_ERR), (Int64)(bhP), (Int64)(bhP->b_rsector), (Int64)(bhP->b_size), (Int64)(bhP->b_state));
#define TRACE_TRCID_KWAITIO_BH_BUSY_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KWAITIO_BH_BUSY), (Int64)(p), (Int64)(atomic_read(&p->nBHActive)));
#define TRACE_TRCID_DISKINFO_CALL \
    _TRACE3D(_HOOKWORD(TRCID_DISKINFO), (Int64)(devId), (Int64)(diskInfoP->sectorSize), (Int64)(diskInfoP->totalSectors));
#define TRACE_TRCID_KXREGISTERCLEANUP_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KXREGISTERCLEANUP_EXIT), (Int64)(Cleanup_fd), (Int64)(iP), (Int64)(rc), (Int64)(code));
#define TRACE_TRCID_LINUXOPS_TSSTAT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSSTAT_ENTER), (Int64)(iP), (Int64)(statP));
#define TRACE_TRCID_LINUXOPS_TSSTAT_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSSTAT_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_TSFSTAT_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_TSFSTAT_ENTER), (Int64)(fileDesc), (Int64)(fP), (Int64)(iP), (Int64)(statP));
#define TRACE_TRCID_LINUXOPS_TSFSTAT_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSFSTAT_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_TSFATTR_ENTER_CALL \
    _TRACE8D(_HOOKWORD(TRCID_LINUXOPS_TSFATTR_ENTER), (Int64)(fileDesc), (Int64)(fP), (Int64)(fP->f_flags), (Int64)(flags), (Int64)(iP), (Int64)(command), (Int64)(argP), (Int64)(rCodeP));
#define TRACE_TRCID_LINUXOPS_TSFATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSFATTR_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_TSATTR_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_TSATTR_ENTER), (Int64)(iP), (Int64)(command), (Int64)(argP), (Int64)(rCodeP));
#define TRACE_TRCID_LINUXOPS_TSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSATTR_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_KXGETACL_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXGETACL_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_KXPUTACL_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXPUTACL_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_KXGETDOSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXGETDOSATTR_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_KXPUTDOSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXPUTDOSATTR_EXIT), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_KXNTACCESS_EXIT_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_KXNTACCESS_EXIT), 3, 0, pathname, (Int64)(ntmask), (Int64)(code), (Int64)(rc));
#define TRACE_TRCID_LINUXOPS_SETSMBOPLOCK_E_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_SETSMBOPLOCK_E), (Int64)(fileDesc), (Int64)(fP), (Int64)(accessWant), (Int64)(oplockWant), (Int64)(breakArgP));
#define TRACE_TRCID_LINUXOPS_SETSMBOPLOCK_X_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_SETSMBOPLOCK_X), (Int64)(*oplockGrantedP), (Int64)(rc));
#define TRACE_TRCID_KXCLAMPLOCKS_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KXCLAMPLOCKS), (Int64)(sbP), (Int64)(gpfs_ops.gpfsClampLocks));
#define TRACE_TRCID_SS_019_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SS_019), (Int64)(filp), (Int64)(inode));
#define TRACE_TRCID_SS_023_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_023), (Int64)(filp));
#define TRACE_TRCID_SS_059_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_059), (Int64)(nbytes));
#define TRACE_TRCID_SS_065_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_065), (Int64)(nbytes));
#define TRACE_TRCID_SS_075_CALL \
    _TRACE5D(_HOOKWORD(TRCID_SS_075), (Int64)(op), (Int64)(ss_ioctl_op[op]), (Int64)(kx_args), (Int64)(inode), (Int64)(file));
#define TRACE_TRCID_SS_077_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_077), (Int64)(op));
#define TRACE_TRCID_SS_081_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_081), (Int64)(major));
#define TRACE_TRCID_SS_083_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_083), (Int64)(GPFSIoctlMajorNumber));
#define TRACE_TRCID_UNPROT_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_UNPROT_ENTER), (Int64)(vaddr), (Int64)(len), (Int64)(allocating));
#define TRACE_TRCID_REPROT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_REPROT_ENTER), (Int64)(vaddr), (Int64)(len));
#define TRACE_TRCID_SHKERN_INIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SHKERN_INIT), (Int64)(VMALLOC_START), (Int64)(VMALLOC_END));
#define TRACE_TRCID_SHKERN_TERM_CALL \
    _TRACE0D(_HOOKWORD(TRCID_SHKERN_TERM));
#define TRACE_TRCID_SSINIT_003_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SSINIT_003), (Int64)(GPFSIoctlMajorNumber));
#define TRACE_TRCID_CALC_MAX_SHARED_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CALC_MAX_SHARED), (Int64)(actualBytes), (Int64)(desiredBytes), (Int64)(physMemSize), (Int64)(vmUsed), (Int64)(maxBytes));
#define TRACE_TRCID_ALLOC_SHARED_VMALLOC_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ALLOC_SHARED_VMALLOC), (Int64)(actualBytes), (Int64)(minBytes));
#define TRACE_TRCID_ALLOC_SHARED_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_ALLOC_SHARED_EXIT), (Int64)(vaddrP), (Int64)(actualBytes), (Int64)(minBytes));
#define TRACE_TRCID_ALLOC_SHARED_FAIL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ALLOC_SHARED_FAIL), (Int64)(actualBytes), (Int64)(minBytes));
#define TRACE_TRCID_MAPALL_MULTI_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MAPALL_MULTI), (Int64)(chunkP));
#define TRACE_TRCID_FREEALL_VFREE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FREEALL_VFREE), (Int64)(chunkP->vaddrP), (Int64)(chunkP));
#define TRACE_TRCID_CXI_MAP_PRIVATE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXI_MAP_PRIVATE), (Int64)(inAddr), (Int64)(len), (Int64)(prot), (Int64)(*outAddr), (Int64)(vmaP));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_1_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_1));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_2), (Int64)(page), (Int64)(page_count(page)), (Int64)(page->index), (Int64)(page->flags));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_6_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_6));
#define TRACE_TRCID_MMAP_FLUSH_LOCK_A_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_LOCK_A), 0, 0, buf);
#define TRACE_TRCID_MMAP_FLUSH_LOCK_B_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_LOCK_B), 0, 0, buf);
#define TRACE_TRCID_MMAP_FLUSH_UNLOCK_A_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_UNLOCK_A), 0, 0, buf);
#define TRACE_TRCID_MMAP_INV_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_INV_ENTER), (Int64)(vma), (Int64)(address), (Int64)(flags), (Int64)(pageP));
#define TRACE_TRCID_MMAP_INV_PRESENT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_INV_PRESENT));
#define TRACE_TRCID_MMAP_INV_PTE_NONE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_INV_PTE_NONE));
#define TRACE_TRCID_MMAP_INVALIDATE_PAGE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MMAP_INVALIDATE_PAGE), (Int64)(pageP), (Int64)(page_count(pageP)), (Int64)(pte_dirty(pte)?1:0));
#define TRACE_TRCID_MMAP_DIRTY_PAGE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_DIRTY_PAGE), (Int64)(page), (Int64)(page_count(page)));
#define TRACE_TRCID_MMAP_WAIT_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_WAIT_ENTER));
#define TRACE_TRCID_MMAP_WAIT_EXIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_WAIT_EXIT));
#define TRACE_TRCID_MMAP_REG_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_REG_ENTER));
#define TRACE_TRCID_MMAP_REG_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_REG_EXIT), (Int64)(rc));
#define TRACE_TRCID_MMAP_UNREG_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_UNREG_ENTER));
#define TRACE_TRCID_MMAP_UNREG_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_UNREG_EXIT), (Int64)(rc));
#define TRACE_TRCID_MMAP_CREATE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_CREATE_EXIT), (Int64)(pid), (Int64)(rc));
#define TRACE_TRCID_MMAP_FILEPOS_ENTER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_FILEPOS_ENTER), (Int64)(pos));
#define TRACE_TRCID_MMAP_RW_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_RW_ENTER), 4, 4, (Int64)(pageP), (Int64)(PAGE_CACHE_SIZE), (Int64)(pageP->index), (Int64)(kaddr), write_req?"write":"read");
#define TRACE_TRCID_MMAP_RW_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_RW_EXIT), (Int64)(rc));
#define TRACE_TRCID_MMAP_IO_ENTER_CALL \
    _TRACE5D(_HOOKWORD(TRCID_MMAP_IO_ENTER), (Int64)(pageP), (Int64)(bufP->b_flags), (Int64)(page_count(pageP)), (Int64)(pageP->flags), (Int64)(pageP->index));
#define TRACE_TRCID_MMAP_IO_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MMAP_IO_EXIT), (Int64)(pageP), (Int64)(page_count(pageP)), (Int64)(pageP->flags));
#define TRACE_TRCID_FLUSH_VMA_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FLUSH_VMA_ENTER), (Int64)(vma), (Int64)(address), (Int64)(size));
#define TRACE_TRCID_FLUSH_VMA_BAD_ADDR_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_ADDR));
#define TRACE_TRCID_PAGE_LOCK_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PAGE_LOCK), (Int64)(vma), (Int64)(address), (Int64)(end), (Int64)(index));
#define TRACE_TRCID_FLUSH_VMA_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_EXIT), (Int64)(error));
#define TRACE_TRCID_MMAP_FLUSH_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_1), (Int64)(vma), (Int64)(vma->vm_file->f_dentry->d_inode->i_ino));
#define TRACE_TRCID_MMAP_FLUSH_2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_2), (Int64)(vma->vm_start), (Int64)(vma->vm_end));
#define TRACE_TRCID_MMAP_FLUSH_3_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_3), (Int64)(start_address), (Int64)(end_address));
#define TRACE_TRCID_MMAP_FLUSH_4_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_FLUSH_4), (Int64)(vma));
#define TRACE_TRCID_MMAP_FLUSH_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_FLUSH_ENTER), (Int64)(gnP), (Int64)(inodeP->i_ino), (Int64)(mmfopt), (Int64)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_ENTER_A_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_ENTER_A), (Int64)((start &PAGE_MASK)), (Int64)((end & PAGE_MASK)));
#define TRACE_TRCID_MMAP_FLUSH_INVAL1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_INVAL1), (Int64)(inodeP->i_ino), (Int64)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_INVAL2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_INVAL2), (Int64)(inodeP->i_ino), (Int64)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_FLUSH_EXIT), (Int64)(rc));
#define TRACE_TRCID_DUMP_OPLOCK_CALL \
    _XTrace(_HOOKWORD(TRCID_DUMP_OPLOCK), "oplock_fcntl: %s on %d (%s %s)\n", cmdstr, (Int64)(fd), omodestr, dmodestr);
#define TRACE_TRCID_NLM_SET_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_SET), (Int64)(lockmode));
#define TRACE_TRCID_NLM_RELEASE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_RELEASE), (Int64)(lockmode));
#define TRACE_TRCID_NLM_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_EXIT), (Int64)(err));
#define TRACE_TRCID_NLM_MOVE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_NLM_MOVE), (Int64)(lockmode), (Int64)(nodenumber));
#define TRACE_TRCID_NLM_MOVE_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_MOVE_EXIT), (Int64)(err));
#define TRACE_TRCID_TESTMOVEOPENLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_TESTMOVEOPENLOCK), (Int64)(fd), (Int64)(cmd), (Int64)(arg));
#define TRACE_TRCID_TESTMOVERECLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_TESTMOVERECLOCK), (Int64)(fd), (Int64)(cmd), (Int64)(arg));
#define TRACE_TRCID_TESTCLAMPLOCKS_CALL \
    _TRACE2D(_HOOKWORD(TRCID_TESTCLAMPLOCKS), (Int64)(fd), (Int64)(clamp));
#define TRACE_TRCID_FCNTL_TOKEN_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_TOKEN), (Int64)(token_want));
#define TRACE_TRCID_FCNTL_SET_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_SET), (Int64)(err));
#define TRACE_TRCID_FCNTL_RELEASE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_RELEASE), (Int64)(token_want));
#define TRACE_TRCID_FCNTL_TOKEN_RELEASE_CALL \
    _STrace(_HOOKWORD(TRCID_FCNTL_TOKEN_RELEASE), 4, 4, (Int64)(deny_type), (Int64)(omode), (Int64)(filp->f_dentry->d_inode->i_dev), (Int64)(filp->f_dentry->d_inode->i_ino), filp->f_dentry->d_name.name);
#define TRACE_TRCID_FCNTL_FILP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FCNTL_FILP));
#define TRACE_TRCID_FCNTL_OPENMODE_OK_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTL_OPENMODE_OK), (Int64)(inode->i_dev), (Int64)(inode->i_ino));
#define TRACE_TRCID_FCNTL_OPENMODE_DENIED_CALL \
    _TRACE4D(_HOOKWORD(TRCID_FCNTL_OPENMODE_DENIED), (Int64)(inode->i_dev), (Int64)(inode->i_ino), (Int64)(err), (Int64)(grant));
#define TRACE_TRCID_FCNTL_OPLOCK_SHARED_CALL \
    _TRACE5D(_HOOKWORD(TRCID_FCNTL_OPLOCK_SHARED), (Int64)(grant), (Int64)(inode->i_dev), (Int64)(inode->i_ino), (Int64)((unsigned long)filp), (Int64)((unsigned long)pfilp));
#define TRACE_TRCID_FCNTL_OPLKACK_OK_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTL_OPLKACK_OK), (Int64)(inode->i_dev), (Int64)(inode->i_ino));
#define TRACE_TRCID_FCNTL_OPLKACK_FAIL_CALL \
    _TRACE4D(_HOOKWORD(TRCID_FCNTL_OPLKACK_FAIL), (Int64)(inode->i_dev), (Int64)(inode->i_ino), (Int64)(grant), (Int64)(err));
#define TRACE_TRCID_FCNTL_STAT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_STAT), (Int64)(err));
#define TRACE_TRCID_OPLOCK_INIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_OPLOCK_INIT));
#define TRACE_TRCID_FLUSH_VMA_PGT_LOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PGT_LOCK), (Int64)(vma));
#define TRACE_TRCID_FLUSH_VMA_BAD_PGD_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PGD));
#define TRACE_TRCID_FLUSH_VMA_BAD_PMD_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PMD));
#define TRACE_TRCID_FLUSH_VMA_BAD_PTE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PTE));
#define TRACE_TRCID_FLUSH_VMA_NONE_PTE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_NONE_PTE));
#define TRACE_TRCID_FLUSH_VMA_PAGE_LOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PAGE_LOCK), (Int64)(page));
#define TRACE_TRCID_FLUSH_VMA_PGT_UNLOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PGT_UNLOCK), (Int64)(vma));

#else /* _ILP_32 */

#define TRACE_TRCID_CXIINC_COUNTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXIINC_COUNTER), (Int32)(ibmModule), (Int32)(up));
#define TRACE_TRCID_GPFSINIT_000_CALL \
    _STrace(_HOOKWORD(TRCID_GPFSINIT_000), 1, 0, prog_path, (Int32)(strlen(prog_path)));
#define TRACE_TRCID_PORTINIT_001_CALL \
    _STrace(_HOOKWORD(TRCID_PORTINIT_001), 1, 0, prog_path, (Int32)(trace_level));
#define TRACE_TRCID_FILE_001_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_001), (Int32)(nbytes));
#define TRACE_TRCID_FILE_003_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_003), (Int32)(nbytes));
#define TRACE_TRCID_FILE_005_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FILE_005));
#define TRACE_TRCID_FILE_071_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FILE_071), (Int32)(inode));
#define TRACE_TRCID_FILE_0712_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FILE_0712), (Int32)(bdP), (Int32)(count));
#define TRACE_TRCID_FILE_072_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FILE_072));
#define TRACE_TRCID_BLOCK_005_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BLOCK_005), (Int32)(inode));
#define TRACE_TRCID_BLOCK_0051_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_0051), (Int32)(bdP), (Int32)(count));
#define TRACE_TRCID_BLOCK_071_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BLOCK_071), (Int32)(inode));
#define TRACE_TRCID_BLOCK_0712_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_0712), (Int32)(bdP), (Int32)(count));
#define TRACE_TRCID_BLOCK_072_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_072));
#define TRACE_TRCID_BLOCK_073_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_073));
#define TRACE_TRCID_BLOCK_074_CALL \
    _TRACE0D(_HOOKWORD(TRCID_BLOCK_074));
#define TRACE_TRCID_BLOCK_011_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_011), (Int32)(GPFSFileSysMajorNumber), (Int32)(rc));
#define TRACE_TRCID_BLOCK_013_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_013), (Int32)(GPFSFileSysMajorNumber), (Int32)(rc));
#define TRACE_TRCID_BLOCK_015_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BLOCK_015), (Int32)(GPFSFileSysMajorNumber), (Int32)(rc));
#define TRACE_TRCID_INVAL_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_DCACHE), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_INVAL_DUNCACHE_CALL \
    _STrace(_HOOKWORD(TRCID_INVAL_DUNCACHE), 1, 0, dentry->d_name.name, (Int32)(holdCount));
#define TRACE_TRCID_INVAL_DCACHE_NOPRUNE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_DCACHE_NOPRUNE), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_DROP_INVAL_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_DROP_INVAL_DCACHE), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_DROP_DUNCACHE_CALL \
    _STrace(_HOOKWORD(TRCID_DROP_DUNCACHE), 1, 0, dentry->d_name.name, (Int32)(holdCount));
#define TRACE_TRCID_INVAL_NEG_DCACHE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_INVAL_NEG_DCACHE), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_DIR_001_CALL \
    _STrace(_HOOKWORD(TRCID_DIR_001), 3, 3, (Int32)(dentry), (Int32)(flags), (Int32)(dentry->d_inode), dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_LLSEEK_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_LLSEEK_ENTER), (Int32)(fP), High32(offset), Low32(offset), (Int32)(origin));
#define TRACE_TRCID_LINUXOPS_LLSEEK_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_LLSEEK_EXIT), (Int32)(fP), High32(offset), Low32(offset), (Int32)(origin));
#define TRACE_TRCID_LINUXOPS_READDIR_ENTER_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_READDIR_ENTER), (Int32)(fP), (Int32)(direntP), (Int32)(filldir), High32(fP->f_pos), Low32(fP->f_pos));
#define TRACE_TRCID_LINUXOPS_READDIR_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READDIR_EXIT), (Int32)(fP), High32(fP->f_pos), Low32(fP->f_pos), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_POLL_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_POLL), (Int32)(fP));
#define TRACE_TRCID_LINUXOPS_IOCTL_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_IOCTL), (Int32)(iP), (Int32)(fP), (Int32)(cmd));
#define TRACE_TRCID_LINUXOPS_MAP_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_MAP_ENTER), (Int32)(file), (Int32)(inode->i_ino), (Int32)(vma));
#define TRACE_TRCID_LINUXOPS_MAP_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_MAP_EXIT), (Int32)(rc), (Int32)(code));
#define TRACE_TRCID_LINUXOPS_NOPAGE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NOPAGE), (Int32)(area), (Int32)(address), (Int32)(no_share));
#define TRACE_TRCID_LINUXOPS_NOPAGE1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_NOPAGE1), 1, 1, (Int32)(inode->i_ino), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"");
#define TRACE_TRCID_LINUXOPS_NOPAGE_NULL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOPAGE_NULL), (Int32)(area), (Int32)(address));
#define TRACE_TRCID_LINUXOPS_PAGE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_PAGE), (Int32)(pageP), (Int32)(pageP->index), (Int32)(page_count(pageP)), (Int32)(pageP->flags));
#define TRACE_TRCID_FM_OPEN_CALL \
    _STrace(_HOOKWORD(TRCID_FM_OPEN), 3, 3, (Int32)(vma), (Int32)(inode->i_ino), (Int32)(atomic_read((atomic_t *)&inode->i_count)), file->f_dentry? file->f_dentry->d_name.name: (const unsigned char*)"");
#define TRACE_TRCID_FM_OPEN_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FM_OPEN_EXIT), (Int32)(vma), (Int32)(atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_FM_CLOSE_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FM_CLOSE_ENTER), (Int32)(vma), (Int32)(inode), (Int32)((Int32)atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_FM_CLOSE_ENTER1_CALL \
    _STrace(_HOOKWORD(TRCID_FM_CLOSE_ENTER1), 2, 1, (Int32)(inode->i_ino), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"", (Int32)(inode->i_data.nrpages));
#define TRACE_TRCID_FM_CLOSE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FM_CLOSE), (Int32)(vma), (Int32)(inode), (Int32)((Int32)atomic_read((atomic_t *)&inode->i_count)));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER), (Int32)(fP), (Int32)(iP->i_ino), (Int32)(vma));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER_A), (Int32)(vma->vm_start), (Int32)(vma->vm_end), (Int32)(vma->vm_pgoff), (Int32)(vma->vm_flags));
#define TRACE_TRCID_LINUXOPS_MMAP_ENTER_A1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MMAP_ENTER_A1), 3, 2, (Int32)(iP->i_ino), (Int32)(atomic_read((atomic_t *)&iP->i_count)), fP->f_dentry ? fP->f_dentry->d_name.name : (const unsigned char*)"", (Int32)(iP->i_data.nrpages));
#define TRACE_TRCID_LINUXOPS_MMAP_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMAP_EXIT), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_OPEN_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_OPEN_ENTER), 6, 4, (Int32)(iP), (Int32)(fP), (Int32)(fP->f_flags), (Int32)(fP->f_dentry), fP->f_dentry? fP->f_dentry->d_name.name: (const unsigned char*)"", (Int32)(flags), (Int32)(cxiIsNFSThread()));
#define TRACE_TRCID_LINUXOPS_OPEN_01_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_OPEN_01), (Int32)(iP), (Int32)(cnP), (Int32)(fflags), (Int32)(amode));
#define TRACE_TRCID_LINUXOPS_OPEN_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_OPEN_EXIT), (Int32)(iP), (Int32)((struct MMFSVInfo *)fP->private_data), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_CLOSE_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_CLOSE_ENTER), (Int32)(iP), (Int32)(fP->f_flags), (Int32)(flags), (Int32)(vinfoP));
#define TRACE_TRCID_CLOSE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CLOSE_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_FSYNC_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_FSYNC_ENTER), (Int32)(fP), (Int32)(direntP), (Int32)(datasync));
#define TRACE_TRCID_LINUXOPS_FSYNC_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FSYNC_EXIT), (Int32)(fP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_FASYNC_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_FASYNC_ENTER), (Int32)(fd), (Int32)(fP), (Int32)(on));
#define TRACE_TRCID_LINUXOPS_FASYNC_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FASYNC_EXIT), (Int32)(fP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_MEDIA_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MEDIA), (Int32)(dev));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_DEV_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_DEV), (Int32)(dev));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER_CALL \
    _XTrace(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER), "gpfs_f_lock enter: pid %d fp 0x%X range 0x%lX:%lX cmd %s type %s\n", (Int32)(flP->fl_pid), (Int32)(fP), (Int32)(flP->fl_start), (Int32)(flP->fl_end), (cmd == F_GETLK) ? "GETLK" : (cmd == F_SETLK) ? "SETLK" : "SETLKW", (flP->fl_type == F_RDLCK) ? "RDLCK" :          (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER2_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER2), (Int32)(fP->f_pos), (Int32)(fP->f_dentry->d_inode), (Int32)(flP->fl_flags), (Int32)(eCred.principal), (Int32)(eCred.group));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_ENTER3_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_ENTER3), (Int32)(nodenumber));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_DIAG2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_DIAG2), (Int32)(fP), (Int32)(fP->f_dentry));
#define TRACE_TRCID_LINUXOPS_LOCKCTL_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_LOCKCTL_EXIT), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_RDWRINT_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RDWRINT_ENTER), 11, 11, (Int32)(fP), (Int32)(fP->f_flags), (Int32)(flags), (Int32)(op), (Int32)(iovecP), (Int32)(count), High32(*offsetP), Low32(*offsetP), (Int32)(fP->f_dentry), (Int32)(fP->private_data), (Int32)(fP->f_dentry->d_inode), fP->f_dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_RDWRINT_EXIT_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_RDWRINT_EXIT), (Int32)(fP), (Int32)(total_len), (Int32)(tmp_uio.uio_resid), High32(tmp_uio.uio_offset), Low32(tmp_uio.uio_offset), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_READ_DIR_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READ_DIR), (Int32)(fP));
#define TRACE_TRCID_PRINTINODE_1_CALL \
    _TRACE7D(_HOOKWORD(TRCID_PRINTINODE_1), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(iP->i_ino), (Int32)(atomic_read((atomic_t *)&iP->i_count)), (Int32)(iP->i_dev), (Int32)(iP->i_mode), (Int32)(iP->i_nlink));
#define TRACE_TRCID_PRINTINODE_2_CALL \
    _TRACE7D(_HOOKWORD(TRCID_PRINTINODE_2), (Int32)(iP->i_uid), (Int32)(iP->i_gid), (Int32)(iP->i_rdev), High32(iP->i_size), Low32(iP->i_size), (Int32)(iP->i_atime), (Int32)(iP->i_mtime));
#define TRACE_TRCID_PRINTINODE_3_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTINODE_3), (Int32)(iP->i_ctime), (Int32)(iP->i_blksize), (Int32)(iP->i_blocks), (Int32)(iP->i_version), (Int32)(iP->i_op));
#define TRACE_TRCID_PRINTINODE_4_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTINODE_4), (Int32)(iP->i_fop), (Int32)(iP->i_sb), (Int32)(iP->i_attr_flags), (Int32)(iP->i_generation), (Int32)(iP->u.generic_ip));
#define TRACE_TRCID_PRINTINODE_5_CALL \
    _TRACE6D(_HOOKWORD(TRCID_PRINTINODE_5), (Int32)(&(iP->i_hash)), (Int32)(iP->i_hash.next), (Int32)(iP->i_hash.prev), (Int32)(&(iP->i_list)), (Int32)(iP->i_list.next), (Int32)(iP->i_list.prev));
#define TRACE_TRCID_PRINTDENTRY_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PRINTDENTRY_1), (Int32)(dP), (Int32)(atomic_read((atomic_t *)&dP->d_count)), (Int32)(dP->d_flags), (Int32)(dP->d_inode));
#define TRACE_TRCID_PRINTDENTRY_2a_CALL \
    _TRACE2D(_HOOKWORD(TRCID_PRINTDENTRY_2a), (Int32)(dP->d_parent), (Int32)(dP->d_hash.next));
#define TRACE_TRCID_PRINTDENTRY_2_CALL \
    _TRACE3D(_HOOKWORD(TRCID_PRINTDENTRY_2), (Int32)(dP->d_parent), (Int32)(dP->d_vfsmnt.next), (Int32)(dP->d_hash.next));
#define TRACE_TRCID_PRINTDENTRY_3_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PRINTDENTRY_3), (Int32)(dP->d_lru.next), (Int32)(dP->d_child.next), (Int32)(dP->d_subdirs.next), (Int32)(dP->d_alias.next));
#define TRACE_TRCID_PRINTDENTRY_4a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTDENTRY_4a), (Int32)(dP->d_time), (Int32)(dP->d_op), (Int32)(dP->d_sb), (Int32)(dP->d_vfs_flags), (Int32)(dP->d_name.name));
#define TRACE_TRCID_PRINTDENTRY_4_CALL \
    _TRACE5D(_HOOKWORD(TRCID_PRINTDENTRY_4), (Int32)(dP->d_time), (Int32)(dP->d_op), (Int32)(dP->d_sb), (Int32)(dP->d_reftime), (Int32)(dP->d_name.name));
#define TRACE_TRCID_PRINTDENTRY_5_CALL \
    _STrace(_HOOKWORD(TRCID_PRINTDENTRY_5), 1, 1, (Int32)(dP->d_fsdata), dP->d_iname);
#define TRACE_TRCID_LINUXOPS_SETINODE_CALL \
    _TRACE8D(_HOOKWORD(TRCID_LINUXOPS_SETINODE), (Int32)(inodeP), (Int32)(inodeP->i_ino), (Int32)(atomic_read((atomic_t *)&inodeP->i_count)), (Int32)(inodeP->i_mode), (Int32)(attrP->va_xinfo), (Int32)(inodeP->i_nlink), High32(inodeP->i_size), Low32(inodeP->i_size));
#define TRACE_TRCID_CXIINVA_PERM_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXIINVA_PERM), (Int32)(cnP), (Int32)(inodeP->i_op == &gpfs_iops_stdperm), (Int32)(inodeP->i_op == &gpfs_dir_iops_stdperm));
#define TRACE_TRCID_LINUXOPS_CREATE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_CREATE_ENTER), 3, 3, (Int32)(diP), (Int32)(dentryP), (Int32)(mode), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_CREATE_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_CREATE_EXIT), (Int32)(newInodeP), (Int32)(iNum), (Int32)(iNum), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_LOOKUP_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_ENTER), 2, 2, (Int32)(diP), (Int32)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_LOOKUP_STALE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_STALE), (Int32)(diP), (Int32)(diP->i_ino));
#define TRACE_TRCID_LINUXOPS_LOOKUP_EXIT_CALL \
    _TRACE7D(_HOOKWORD(TRCID_LINUXOPS_LOOKUP_EXIT), (Int32)(newInodeP), (Int32)(iNum), (Int32)(iNum), (Int32)(cnP), (Int32)(retP), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_LINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_LINK_ENTER), 3, 3, (Int32)(diP), (Int32)(oldDentryP), (Int32)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_LINK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_LINK_EXIT), (Int32)(diP), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_UNLINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_UNLINK_ENTER), 3, 3, (Int32)(diP), (Int32)(iP), (Int32)(dentryP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_UNLINK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_UNLINK_EXIT), (Int32)(diP), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_SYMLINK1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_SYMLINK1), 2, 2, (Int32)(diP), (Int32)(dentryP), symlinkTargetP);
#define TRACE_TRCID_LINUXOPS_SYMLINK2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_SYMLINK2), 0, 0, dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_SYMLINK_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_SYMLINK_EXIT), (Int32)(newInodeP), (Int32)(iNum), (Int32)(iNum), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_MKDIR_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MKDIR_ENTER), 2, 2, (Int32)(diP), (Int32)(mode), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_MKDIR_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MKDIR_EXIT), (Int32)(newInodeP), (Int32)(iNum), (Int32)(iNum), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_RMDIR_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RMDIR_ENTER), 2, 2, (Int32)(diP), (Int32)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RMDIR_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_RMDIR_EXIT), (Int32)(diP), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_MKNOD_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_MKNOD_ENTER), 3, 3, (Int32)(diP), (Int32)(mode), (Int32)(rdev), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_MKNOD_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MKNOD_EXIT), (Int32)(newInodeP), (Int32)(iNum), (Int32)(iNum), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_RENAME_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RENAME_1), 2, 2, (Int32)(iP), (Int32)(diP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RENAME_2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_RENAME_2), 2, 2, (Int32)(tiP), (Int32)(tdiP), tDentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_RENAME_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_RENAME_EXIT), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_READLINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READLINK_ENTER), 4, 4, (Int32)(dentryP), (Int32)(bufP), (Int32)(buflen), (Int32)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_READLINK_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READLINK_EXIT), (Int32)(iP), (Int32)(tmpUio.uio_resid), (Int32)(tmpUio.uio_offset), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_ENTER), 1, 1, (Int32)(dentry->d_inode), dentry->d_name.name);
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_1), 1, 1, (Int32)(rc), buf);
#define TRACE_TRCID_LINUXOPS_FOLLOW_LINK_2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_FOLLOW_LINK_2), (Int32)(dentry->d_inode), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_READPAGE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READPAGE_ENTER), 3, 3, (Int32)(dentryP), (Int32)(pageP), (Int32)(iP), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_READPAGE_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_READPAGE_ENTER_A), (Int32)(pageP), (Int32)(pageP->index), (Int32)(page_count(pageP)), (Int32)(pageP->flags));
#define TRACE_TRCID_LINUXOPS_READPAGE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READPAGE_EXIT), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_WRPAGE_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_ENTER), (Int32)(pageP), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_LINUXOPS_WRPAGE_ENTER_A_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_ENTER_A), (Int32)(pageP), (Int32)(pageP->index), (Int32)(page_count(pageP)), (Int32)(pageP->flags));
#define TRACE_TRCID_LINUXOPS_WRPAGE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_WRPAGE_EXIT), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_TRUNCATE_PAGE_ENTER_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_TRUNCATE_PAGE_ENTER), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(atomic_read((atomic_t *)&iP->i_count)), (Int32)(pageP), (Int32)(page_count(pageP)));
#define TRACE_TRCID_LINUXOPS_BMAP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_BMAP));
#define TRACE_TRCID_LINUXOPS_TRUNCATE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_TRUNCATE), (Int32)(iP));
#define TRACE_TRCID_LINUXOPS_ACCESS_ENTER_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_ACCESS_ENTER), (Int32)(iP), (Int32)(mode), (Int32)(current->fsuid), (Int32)(current->fsgid), (Int32)(iP->i_mode), (Int32)(cnP->xinfo));
#define TRACE_TRCID_LINUXOPS_ACCESS_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_ACCESS_EXIT), (Int32)(iP), (Int32)(iP->i_op == &gpfs_iops_stdperm), (Int32)(iP->i_op == &gpfs_dir_iops_stdperm), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_SMAP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_SMAP));
#define TRACE_TRCID_LINUXOPS_UPDATEPAGE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_UPDATEPAGE));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_ENTER), 3, 3, (Int32)(dentryP), (Int32)(dentryP->d_inode), (Int32)((iP) ? iP->i_ino : -1), dentryP->d_name.name);
#define TRACE_TRCID_LINUXOPS_REVALIDATE_STALE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_STALE), (Int32)(iP), (Int32)(iP->i_ino));
#define TRACE_TRCID_REVAL_DELAY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_REVAL_DELAY), (Int32)(howLong));
#define TRACE_TRCID_REVAL_DELAY_END_CALL \
    _TRACE1D(_HOOKWORD(TRCID_REVAL_DELAY_END), (Int32)(howLong));
#define TRACE_TRCID_LINUXOPS_REVALIDATE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REVALIDATE_EXIT), (Int32)(dentryP), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_SETATTR_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_SETATTR_ENTER), (Int32)(iP), (Int32)(aP->ia_valid), (Int32)(aP->ia_attr_flags));
#define TRACE_TRCID_LINUXOPS_SETATTR_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_SETATTR_EXIT), (Int32)(iP), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_GETATTR_ENTER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_GETATTR_ENTER), (Int32)(iP));
#define TRACE_TRCID_LINUXOPS_GETATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_GETATTR_EXIT), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_VNODE_BKL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_VNODE_BKL), (Int32)(kernel_locked()), (Int32)(current->lock_depth));
#define TRACE_TRCID_LINUXOPS_READINODE_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READINODE_ENTER), (Int32)(iP), (Int32)(inum));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_1), (Int32)(iP), (Int32)(cnP), (Int32)(sizeof(iP->u) - sizeof(void *)), (Int32)(CXINODE_SIZE));
#define TRACE_TRCID_LINUXOPS_READINODE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READINODE_EXIT), (Int32)(iP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_READINODE_HUH_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_READINODE_HUH));
#define TRACE_TRCID_LINUXOPS_DELETE_INODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_DELETE_INODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(isGPFS));
#define TRACE_TRCID_LINUXOPS_DELETE_INODE_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_DELETE_INODE_1), (Int32)(iP), (Int32)(cnP));
#define TRACE_TRCID_LINUXOPS_NOTIFY_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOTIFY_ENTER), (Int32)(dentryP->d_inode), (Int32)(attrP));
#define TRACE_TRCID_LINUXOPS_NOTIFY_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NOTIFY_EXIT), (Int32)(dentryP->d_inode), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_PUTSUPER_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_PUTSUPER_ENTER), (Int32)(sbP), (Int32)(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_PUTSUPER_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_PUTSUPER_EXIT), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_STATFS_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_STATFS_ENTER), (Int32)(sbP), (Int32)(len));
#define TRACE_TRCID_LINUXOPS_STATFS_EXIT_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_STATFS_EXIT), (Int32)(bufP->f_blocks), (Int32)(bufP->f_bfree), (Int32)(bufP->f_files), (Int32)(bufP->f_ffree), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_UMOUNT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_UMOUNT_ENTER), (Int32)(sbP), (Int32)(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_UMOUNT_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UMOUNT_EXIT), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_REMOUNT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_REMOUNT));
#define TRACE_TRCID_LINUXOPS_WRITEINODE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_WRITEINODE));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(iP->u.generic_ip));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_DETAILS_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE_DETAILS), (Int32)(VP_TO_CNP(iP)), (Int32)(VP_TO_PVP(iP)), (Int32)(NODE_TOO_BIG_FOR_OSNODE(CXINODE_SIZE)));
#define TRACE_TRCID_LINUXOPS_CLEARINODE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_CLEARINODE_EXIT), (Int32)(iP), (Int32)(iP->u.generic_ip), (Int32)(code));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER), (Int32)(sbP));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_3_CALL \
    _TRACE0D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER_3));
#define TRACE_TRCID_LINUXOPS_WRITESUPER_5_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_WRITESUPER_5), (Int32)(sbP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_READSUPER_1_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_1), 3, 3, (Int32)(sbP), (Int32)(sbP->s_dev), (Int32)(silent), ((char *)dataP == NULL) ? "" : dataP);
#define TRACE_TRCID_LINUXOPS_READSUPER_2_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_2), 0, 0, bdevname(sbP->s_dev));
#define TRACE_TRCID_LINUXOPS_READSUPER_STARTHELPER_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_READSUPER_STARTHELPER), 0, 0, mmfs_path);
#define TRACE_TRCID_LINUXOPS_READSUPER_HELPERRC_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_HELPERRC), (Int32)(mountHelperID));
#define TRACE_TRCID_LINUXOPS_READSUPER_SUCCEED_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_SUCCEED), (Int32)(sbP));
#define TRACE_TRCID_LINUXOPS_READSUPER_FAILED_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_READSUPER_FAILED), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_REGFS_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_REGFS), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_UNREGFS_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UNREGFS), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_1), (Int32)(inode), (Int32)(filp), (Int32)(current->pid), (Int32)(inode->u.generic_ip));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_2_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_2), (Int32)(mmfsd_id));
#define TRACE_TRCID_LINUXOPS_MMFSD_RELEASE_3_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_MMFSD_RELEASE_3), (Int32)(mount_id));
#define TRACE_TRCID_LINUXOPS_KILLMMFSD_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_KILLMMFSD), (Int32)(mmfsd_id));
#define TRACE_TRCID_SWAPD_CLEARINODE_CALL \
    _TRACE5D_NB(_HOOKWORD(TRCID_SWAPD_CLEARINODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(unusedInodeP), (Int32)(unusedSuperP), (Int32)(unusedInodeNum));
#define TRACE_TRCID_SWAPD_READINODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_SWAPD_READINODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(unusedInodeP), (Int32)(unusedSuperP), (Int32)(unusedInodeNum));
#define TRACE_TRCID_ADDOSNODE_UNUSED_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ADDOSNODE_UNUSED), (Int32)(iP), (Int32)(sbP), (Int32)(unusedInodeNum), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_EXECMMFS_1_CALL \
    _XTrace(_HOOKWORD(TRCID_LINUXOPS_EXECMMFS_1), "exec_mmfs: mmfs_path %s mount_opt %s\n", mmfs_path, mount_opt);
#define TRACE_TRCID_LINUXOPS_EXECMMFS_EXIT_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_EXECMMFS_EXIT), 3, 3, (Int32)(rc), (Int32)(code), (Int32)(errno), mmfs_path);
#define TRACE_TRCID_LINUXOPS_FORK_MOUNTHELPER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_FORK_MOUNTHELPER), (Int32)(mount_id));
#define TRACE_TRCID_SET_MOUNT_INFO_CALL \
    _TRACE4D(_HOOKWORD(TRCID_SET_MOUNT_INFO), (Int32)(sbP), (Int32)(rootIP), (Int32)(cnRootP), (Int32)(gnRootP));
#define TRACE_TRCID_LINUXOPS_UNMOUNTINT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_UNMOUNTINT_ENTER), (Int32)(sbP), (Int32)(force));
#define TRACE_TRCID_LINUXOPS_UNMOUNTINT_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_UNMOUNTINT_EXIT), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_REACTIVATE_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REACTIVATE_VNODE), (Int32)(osVfsP), (Int32)(cnP), (Int32)(osNodePP));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE), (Int32)(sbP), (Int32)(inum), (Int32)(nodeSize));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_EXIT), (Int32)(*osNodePP), (Int32)(*cnPP), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_NEW_VNODE_BAD_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_NEW_VNODE_BAD), (Int32)(nodeSize), (Int32)(CXINODE_SIZE));
#define TRACE_TRCID_LINUXOPS_DELETE_VNODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_DELETE_VNODE), (Int32)(sbP), (Int32)(cnP), (Int32)(iP), (Int32)(iP ? iP->i_ino : -1), (Int32)(iP ? atomic_read((atomic_t *)&iP->i_count) : 0));
#define TRACE_TRCID_LINUXOPS_DELETE_MMAP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_LINUXOPS_DELETE_MMAP), (Int32)(segid));
#define TRACE_TRCID_LINUXOPS_REINIT_VNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_REINIT_VNODE), (Int32)(sbP), (Int32)(cnP), (Int32)(iP));
#define TRACE_TRCID_LINUXOPS_FIND_VNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_FIND_VNODE), (Int32)(sbP), (Int32)(cnP), (Int32)(*osNodePP), (Int32)(iP ? atomic_read((atomic_t *)&iP->i_count) : 0), (Int32)(holdit), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_DUMP_VNODE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_DUMP_VNODE), (Int32)(cnP), (Int32)(iP));
#define TRACE_TRCID_LINUXOPS_REF_VNODE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_REF_VNODE), (Int32)(osVfsP), (Int32)(cnP), (Int32)(iP), (Int32)(ino), (Int32)(holdCount));
#define TRACE_TRCID_LINUXOPS_INACTIVE_VNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_INACTIVE_VNODE), (Int32)(sbP), (Int32)(cnP), (Int32)(iP), (Int32)(holdCount), (Int32)(*canCacheP), (Int32)(*hasReferencesP));
#define TRACE_TRCID_LINUXOPS_PUT_OSNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_PUT_OSNODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(holdCount-1));
#define TRACE_TRCID_LINUXOPS_DESTROY_OSNODE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_DESTROY_OSNODE), (Int32)(iP), (Int32)(iP->i_ino), (Int32)(holdCount), (Int32)(iP->i_nlink));
#define TRACE_TRCID_CXIUPDATE_INODE_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_CXIUPDATE_INODE_2), (Int32)(iP), (Int32)(iP->i_atime), (Int32)(iP->i_mtime), (Int32)(iP->i_ctime));
#define TRACE_TRCID_CXIUPDATE_INODE_1_CALL \
    _TRACE8D(_HOOKWORD(TRCID_CXIUPDATE_INODE_1), (Int32)(what), (Int32)(iP->i_mode), (Int32)(iP->i_uid), (Int32)(iP->i_gid), (Int32)(iP->i_nlink), High32(iP->i_size), Low32(iP->i_size), (Int32)(iP->i_blocks));
#define TRACE_TRCID_LINUXOPS_CANUNCACHE_OSNODE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_LINUXOPS_CANUNCACHE_OSNODE), (Int32)(cnP), (Int32)(vP), (Int32)(osVfsP), (Int32)((iP ? iP->i_sb : 0)), (Int32)((iP ? iP->i_ino : 0)), (Int32)(count));
#define TRACE_TRCID_LINUXOPS_ADD_OSNODE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_LINUXOPS_ADD_OSNODE), (Int32)(dentryP), (Int32)(vP), (Int32)(d_unhashed(dP)));
#define TRACE_TRCID_FCNTLLOCK_ENTER_CALL \
    _XTrace(_HOOKWORD(TRCID_FCNTLLOCK_ENTER), "cxiFcntlLock posix_lock_file: pid %d owner 0x%X inodeP 0x%X "          "range 0x%lX-%lX cmd %s type %s\n", (Int32)(flP->fl_pid), (Int32)(flP->fl_owner), (Int32)(advObjP), (Int32)(flP->fl_start), (Int32)(flP->fl_end), (cmd == F_GETLK) ? "GETLK" : (cmd == F_SETLK) ? "SETLK" : "SETLKW", (flP->fl_type == F_RDLCK) ? "RDLCK" :          (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_FCNTLLOCK_GETLK_CALL \
    _STrace(_HOOKWORD(TRCID_FCNTLLOCK_GETLK), 5, 5, (Int32)(flP->fl_pid), (Int32)(flP->fl_owner), (Int32)(advObjP), (Int32)(flP->fl_start), (Int32)(flP->fl_end), (flP->fl_type == F_RDLCK) ? "RDLCK" :            (flP->fl_type == F_WRLCK) ? "WRLCK" : "UNLCK");
#define TRACE_TRCID_FCNTLLOCK_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTLLOCK_EXIT), (Int32)(rc), (Int32)(cflP));
#define TRACE_TRCID_SLEEP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SLEEP), (Int32)(ms));
#define TRACE_TRCID_SLEEP_END_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SLEEP_END), (Int32)(ms), (Int32)(HZ));
#define TRACE_TRCID_OPENNFS_CALL \
    _TRACE7D(_HOOKWORD(TRCID_OPENNFS), (Int32)(inodeP), (Int32)((inodeP) ? inodeP->i_ino : -1), (Int32)((inodeP) ? inodeP->i_ino : -1), (Int32)((inodeP) ? inodeP->i_mode : -1), (Int32)((inodeP) ? inodeP->i_nlink : -1), (Int32)((inodeP) ? inodeP->u.generic_ip : NULL), (Int32)(refcount));
#define TRACE_TRCID_CXISTART_KPROC_LINUX_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTART_KPROC_LINUX), 1, 0, kpdP->nameP, (Int32)(kpdP->pid));
#define TRACE_TRCID_CXISTOP_KPROC_LINUX_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTOP_KPROC_LINUX), 1, 0, kpdP->nameP, (Int32)(kpdP->pid));
#define TRACE_TRCID_CXISTOP_KPROC_STILL_ALIVE_CALL \
    _STrace(_HOOKWORD(TRCID_CXISTOP_KPROC_STILL_ALIVE), 1, 0, kpdP->nameP, (Int32)(pid));
#define TRACE_TRCID_PANIC_CALL \
    _STrace(_HOOKWORD(TRCID_PANIC), 0, 0, panicStrP);
#define TRACE_TRCID_MODULE_LOGASSERT_1_CALL \
    _STrace(_HOOKWORD(TRCID_MODULE_LOGASSERT_1), 2, 0, failingExpr, (Int32)(retCode), (Int32)(reasonCode));
#define TRACE_TRCID_MODULE_LOGASSERT_2_CALL \
    _STrace(_HOOKWORD(TRCID_MODULE_LOGASSERT_2), 1, 0, srcFileName, (Int32)(srcLineNumber));
#define TRACE_TRCID_CXISYSTEM_001_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_001), (Int32)(lockP->slCount), (Int32)(lockP->slState), (Int32)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_003_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_003), (Int32)(lockP->slCount), (Int32)(lockP->slState), (Int32)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SUNLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SUNLOCK), (Int32)(lockP->slCount), (Int32)(lockP->slState), (Int32)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SUNLOCK_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SUNLOCK_EXIT), (Int32)(lockP->slCount), (Int32)(lockP->slState), (Int32)(lockP->slOwnerP));
#define TRACE_TRCID_CXISYSTEM_SLEEP_THREAD_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SLEEP_THREAD_ENTER), (Int32)(weP), (Int32)(sl), (Int32)(waitFlags));
#define TRACE_TRCID_CXISYSTEM_SLEEP_THREAD_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_SLEEP_THREAD_EXIT), (Int32)(weP), (Int32)(sl), (Int32)(waitElement.wakeupRC));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP), (Int32)(weP));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_ONE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP_ONE), (Int32)(weP));
#define TRACE_TRCID_CXISYSTEM_WAKEUP_RESULT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_WAKEUP_RESULT), (Int32)(weP), (Int32)(rc));
#define TRACE_TRCID_CXISYSTEM_037_CALL \
    _TRACE4D(_HOOKWORD(TRCID_CXISYSTEM_037), (Int32)(kBufP), (Int32)(uioP), (Int32)(nBytes), (Int32)(toKernel));
#define TRACE_TRCID_CXISYSTEM_039a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXISYSTEM_039a), (Int32)(rc), (Int32)(trcdata[0]), (Int32)(trcdata[1]), (Int32)(trcdata[2]), (Int32)(trcdata[3]));
#define TRACE_TRCID_CXISYSTEM_039_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_039), (Int32)(rc));
#define TRACE_TRCID_CXISYSTEM_041a_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXISYSTEM_041a), (Int32)(rc), (Int32)(trcdata[0]), (Int32)(trcdata[1]), (Int32)(trcdata[2]), (Int32)(trcdata[3]));
#define TRACE_TRCID_CXISYSTEM_041_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_041), (Int32)(rc));
#define TRACE_TRCID_CXISYSTEM_CHKTYPES_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_CHKTYPES), (Int32)(rc));
#define TRACE_TRCID_BM_INIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_INIT), (Int32)(mP), (Int32)(bmNameIdx));
#define TRACE_TRCID_BM_ACQ_CALL \
    _TRACE4D(_HOOKWORD(TRCID_BM_ACQ), (Int32)(mP), (Int32)(mP->lockNameIndex), (Int32)(current), (Int32)(currentOwner));
#define TRACE_TRCID_BM_ACQ_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BM_ACQ_EXIT), (Int32)(mP));
#define TRACE_TRCID_BM_REL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_REL), (Int32)(mP), (Int32)(mP->lockNameIndex));
#define TRACE_TRCID_BM_TERM_CALL \
    _TRACE2D(_HOOKWORD(TRCID_BM_TERM), (Int32)(mP), (Int32)(mP->lockNameIndex));
#define TRACE_TRCID_CXISYSTEM_017_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_017), (Int32)(ownerP), (Int32)(result));
#define TRACE_TRCID_CXISYSTEM_018_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_018), (Int32)(mP), (Int32)(result));
#define TRACE_TRCID_CXISYSTEM_EVENT_WAIT_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_EVENT_WAIT_ENTER), (Int32)(weP), (Int32)(waitFlags), (Int32)(mutexP));
#define TRACE_TRCID_CXISYSTEM_EVENT_WAIT_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXISYSTEM_EVENT_WAIT_EXIT), (Int32)(weP), (Int32)(mutexP), (Int32)(waitElement.wakeupRC));
#define TRACE_TRCID_CXISYSTEM_SIGNAL_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_SIGNAL), (Int32)(weP));
#define TRACE_TRCID_CXISYSTEM_BROADCAST_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXISYSTEM_BROADCAST), (Int32)(weP));
#define TRACE_TRCID_CXISYSTEM_BROADCAST_RC_CALL \
    _TRACE2D(_HOOKWORD(TRCID_CXISYSTEM_BROADCAST_RC), (Int32)(weP), (Int32)(rc));
#define TRACE_TRCID_SMBOPENLOCKCONTROL_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SMBOPENLOCKCONTROL_1), (Int32)(command), (Int32)(lockmode));
#define TRACE_TRCID_SMBOPENLOCKCONTROL_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SMBOPENLOCKCONTROL_EXIT), (Int32)(rc));
#define TRACE_TRCID_SMBOPENLOCKMOVE_1_CALL \
    _TRACE3D(_HOOKWORD(TRCID_SMBOPENLOCKMOVE_1), (Int32)(command), (Int32)(lockmode), (Int32)(nodenumber));
#define TRACE_TRCID_SMBOPENLOCKMOVE_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SMBOPENLOCKMOVE_EXIT), (Int32)(rc));
#define TRACE_TRCID_CXICHECKOPEN_ENTRY_CALL \
    _TRACE3D(_HOOKWORD(TRCID_CXICHECKOPEN_ENTRY), (Int32)(count), (Int32)(inodeP->i_ino), (Int32)(inodeP));
#define TRACE_TRCID_CXICHECKOPEN_FOUND_CALL \
    _TRACE1D(_HOOKWORD(TRCID_CXICHECKOPEN_FOUND), (Int32)(fileP->private_data));
#define TRACE_TRCID_KIBD_NEW_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_NEW), (Int32)(kibdP));
#define TRACE_TRCID_KIBD_DELETE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_DELETE), (Int32)(kibdP));
#define TRACE_TRCID_DEALLOC_KIBD_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_DEALLOC_KIBD_1), (Int32)(kibdPrevP), (Int32)(kibdPrevP->kibdVaddr), (Int32)(kibdPrevP->kibdPages), (Int32)(kibdP));
#define TRACE_TRCID_DEALLOC_KIBD_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_DEALLOC_KIBD_2), (Int32)(kibdPrevP), (Int32)(kibdPrevP->kibdVaddr), (Int32)(kibdPrevP->kibdPages), (Int32)(kibdP));
#define TRACE_TRCID_ALLOC_KIBD_1_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_1), (Int32)(kibdPrevP), (Int32)(kibdPrevP->kibdVaddr), (Int32)(kibdPrevP->kibdPages), (Int32)(kibdP));
#define TRACE_TRCID_ALLOC_KIBD_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_2), (Int32)(kibdP), (Int32)(kibdP->kibdVaddr), (Int32)(kibdP->kibdPages), (Int32)(totalPages));
#define TRACE_TRCID_ALLOC_KIBD_UNCACHE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_ALLOC_KIBD_UNCACHE), (Int32)(kibdHeadP), (Int32)(pageP), (Int32)(atomic_read(&pageP->count)), (Int32)(addrSpaceP));
#define TRACE_TRCID_KIBD_INIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_INIT));
#define TRACE_TRCID_KIBD_TERM_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_TERM));
#define TRACE_TRCID_BHC_CACHE_DESTROY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_BHC_CACHE_DESTROY), (Int32)(rc));
#define TRACE_TRCID_KIBD_CACHE_DESTROY_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBD_CACHE_DESTROY), (Int32)(rc));
#define TRACE_TRCID_KIBDPIN_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KIBDPIN_ENTER), (Int32)(vaddr), (Int32)(len));
#define TRACE_TRCID_KIBDPIN_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_KIBDPIN_EXIT), (Int32)(headP));
#define TRACE_TRCID_KIBD_UNPIN_ALL_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_UNPIN_ALL_ENTER));
#define TRACE_TRCID_KIBD_UNPIN_ALL_EXIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_KIBD_UNPIN_ALL_EXIT));
#define TRACE_TRCID_KIBD_SPLIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KIBD_SPLIT), (Int32)(kibdP), (Int32)(vaddr), (Int32)(nPages), (Int32)(frontPages));
#define TRACE_TRCID_KIBD_SPLIT_EXIT_CALL \
    _TRACE5D(_HOOKWORD(TRCID_KIBD_SPLIT_EXIT), (Int32)(frontP), (Int32)(frontPages), (Int32)(rearP), (Int32)(nPages-frontPages), (Int32)(rc));
#define TRACE_TRCID_KIBD_MERGE_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KIBD_MERGE), (Int32)(frontP), (Int32)(vaddr), (Int32)(nPages), (Int32)(rearP), (Int32)(rearP->kibdVaddr), (Int32)(rearP->kibdTotalPages));
#define TRACE_TRCID_KIBD_MERGE_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KIBD_MERGE_EXIT), (Int32)(mergedP), (Int32)(vaddr), (Int32)(nPages), (Int32)(rc));
#define TRACE_TRCID_ATTACH_ENTER_CALL \
    _TRACE1D(_HOOKWORD(TRCID_ATTACH_ENTER), (Int32)(OffsetToDataPtr(iobP,0,0)));
#define TRACE_TRCID_ATTACH_KIBD_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ATTACH_KIBD), (Int32)(iobP->kernelIOBufferDescP), (Int32)(newPinCount));
#define TRACE_TRCID_DETACH_KIBD_CALL \
    _TRACE3D(_HOOKWORD(TRCID_DETACH_KIBD), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(attachP->kDescP), (Int32)(iobP->pinCount));
#define TRACE_TRCID_UXFER_LINUX_CALL \
    _TRACE5D(_HOOKWORD(TRCID_UXFER_LINUX), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(kibdP), (Int32)(toIOBuffer), (Int32)(bufOffset), (Int32)(len));
#define TRACE_TRCID_UXFER_UIOMOVE_CALL \
    _TRACE4D(_HOOKWORD(TRCID_UXFER_UIOMOVE), (Int32)(pageIndex), (Int32)(kaddr), (Int32)(pageOffset), (Int32)(pageLen));
#define TRACE_TRCID_KXFER_LINUX_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KXFER_LINUX), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(kibdP), (Int32)(toIOBuffer), (Int32)(bufOffset), (Int32)(len), (Int32)(kBufP));
#define TRACE_TRCID_KXFER_MEMCPY_CALL \
    _TRACE5D(_HOOKWORD(TRCID_KXFER_MEMCPY), (Int32)(kibdP), (Int32)(pageIndex), (Int32)(kaddr), (Int32)(pageOffset), (Int32)(pageLen));
#define TRACE_TRCID_KZERO_LINUX_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KZERO_LINUX), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(kibdP), (Int32)(bufOffset), (Int32)(len));
#define TRACE_TRCID_KZERO_MEMSET_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KZERO_MEMSET), (Int32)(pageIndex), (Int32)(kaddr), (Int32)(pageOffset), (Int32)(pageLen));
#define TRACE_TRCID_MAP_DISCONTIG_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MAP_DISCONTIG_ENTER), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(kibdP), (Int32)(iobP->ioBufLen));
#define TRACE_TRCID_MAP_DISCONTIG_KMAP_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MAP_DISCONTIG_KMAP), (Int32)(pageIndex), (Int32)(kibdP), (Int32)(pageP), (Int32)(kaddr));
#define TRACE_TRCID_UNMAP_DISCONTIG_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_UNMAP_DISCONTIG_ENTER), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(iobP->kernelIOBufferDescP), (Int32)(iobP->ioBufLen), (Int32)(discontigP->mappedLen));
#define TRACE_TRCID_UNMAP_DISCONTIG_KUNMAP_CALL \
    _TRACE3D(_HOOKWORD(TRCID_UNMAP_DISCONTIG_KUNMAP), (Int32)(pageIndex), (Int32)(pageP), (Int32)(discontigP->userPagePointerArray[pageIndex]));
#define TRACE_TRCID_MAP_CONTIG_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MAP_CONTIG_ENTER), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(kibdP), (Int32)(bufOffset), (Int32)(len));
#define TRACE_TRCID_MAP_CONTIG_KMAP_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MAP_CONTIG_KMAP), (Int32)(pageP), (Int32)(*contigBasePP));
#define TRACE_TRCID_MAP_CONTIG_VMALLOC_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MAP_CONTIG_VMALLOC), (Int32)(tempBufP));
#define TRACE_TRCID_UNMAP_CONTIG_VFREE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_UNMAP_CONTIG_VFREE), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(contigP->mallocedBaseP));
#define TRACE_TRCID_UNMAP_CONTIG_KUNMAP_CALL \
    _TRACE2D(_HOOKWORD(TRCID_UNMAP_CONTIG_KUNMAP), (Int32)(OffsetToDataPtr(iobP,0,0)), (Int32)(contigP->pageP));
#define TRACE_TRCID_KDOIO_LINUX_CALL \
    _TRACE6D(_HOOKWORD(TRCID_KDOIO_LINUX), (Int32)(kibdP), (Int32)(isWrite), (Int32)(dev), (Int32)(startSector), (Int32)(nSectors), (Int32)(bufOffset));
#define TRACE_TRCID_KDOIO_LINUX_BH_CALL \
    _TRACE3D(_HOOKWORD(TRCID_KDOIO_LINUX_BH), (Int32)(bhP), (Int32)(startSector), (Int32)(sectorsThisBH));
#define TRACE_TRCID_KWAITIO_BH_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KWAITIO_BH), (Int32)(bhP), (Int32)(bhP->b_rsector), (Int32)(bhP->b_size), (Int32)(bhP->b_state));
#define TRACE_TRCID_KWAITIO_BH_ERR_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KWAITIO_BH_ERR), (Int32)(bhP), (Int32)(bhP->b_rsector), (Int32)(bhP->b_size), (Int32)(bhP->b_state));
#define TRACE_TRCID_KWAITIO_BH_BUSY_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KWAITIO_BH_BUSY), (Int32)(p), (Int32)(atomic_read(&p->nBHActive)));
#define TRACE_TRCID_DISKINFO_CALL \
    _TRACE4D(_HOOKWORD(TRCID_DISKINFO), (Int32)(devId), (Int32)(diskInfoP->sectorSize), High32(diskInfoP->totalSectors), Low32(diskInfoP->totalSectors));
#define TRACE_TRCID_KXREGISTERCLEANUP_EXIT_CALL \
    _TRACE4D(_HOOKWORD(TRCID_KXREGISTERCLEANUP_EXIT), (Int32)(Cleanup_fd), (Int32)(iP), (Int32)(rc), (Int32)(code));
#define TRACE_TRCID_LINUXOPS_TSSTAT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSSTAT_ENTER), (Int32)(iP), (Int32)(statP));
#define TRACE_TRCID_LINUXOPS_TSSTAT_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSSTAT_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_TSFSTAT_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_TSFSTAT_ENTER), (Int32)(fileDesc), (Int32)(fP), (Int32)(iP), (Int32)(statP));
#define TRACE_TRCID_LINUXOPS_TSFSTAT_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSFSTAT_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_TSFATTR_ENTER_CALL \
    _TRACE8D(_HOOKWORD(TRCID_LINUXOPS_TSFATTR_ENTER), (Int32)(fileDesc), (Int32)(fP), (Int32)(fP->f_flags), (Int32)(flags), (Int32)(iP), (Int32)(command), (Int32)(argP), (Int32)(rCodeP));
#define TRACE_TRCID_LINUXOPS_TSFATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSFATTR_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_TSATTR_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_LINUXOPS_TSATTR_ENTER), (Int32)(iP), (Int32)(command), (Int32)(argP), (Int32)(rCodeP));
#define TRACE_TRCID_LINUXOPS_TSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_TSATTR_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_KXGETACL_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXGETACL_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_KXPUTACL_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXPUTACL_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_KXGETDOSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXGETDOSATTR_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_KXPUTDOSATTR_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_KXPUTDOSATTR_EXIT), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_KXNTACCESS_EXIT_CALL \
    _STrace(_HOOKWORD(TRCID_LINUXOPS_KXNTACCESS_EXIT), 3, 0, pathname, (Int32)(ntmask), (Int32)(code), (Int32)(rc));
#define TRACE_TRCID_LINUXOPS_SETSMBOPLOCK_E_CALL \
    _TRACE5D(_HOOKWORD(TRCID_LINUXOPS_SETSMBOPLOCK_E), (Int32)(fileDesc), (Int32)(fP), (Int32)(accessWant), (Int32)(oplockWant), (Int32)(breakArgP));
#define TRACE_TRCID_LINUXOPS_SETSMBOPLOCK_X_CALL \
    _TRACE2D(_HOOKWORD(TRCID_LINUXOPS_SETSMBOPLOCK_X), (Int32)(*oplockGrantedP), (Int32)(rc));
#define TRACE_TRCID_KXCLAMPLOCKS_CALL \
    _TRACE2D(_HOOKWORD(TRCID_KXCLAMPLOCKS), (Int32)(sbP), (Int32)(gpfs_ops.gpfsClampLocks));
#define TRACE_TRCID_SS_019_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SS_019), (Int32)(filp), (Int32)(inode));
#define TRACE_TRCID_SS_023_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_023), (Int32)(filp));
#define TRACE_TRCID_SS_059_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_059), (Int32)(nbytes));
#define TRACE_TRCID_SS_065_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_065), (Int32)(nbytes));
#define TRACE_TRCID_SS_075_CALL \
    _TRACE5D(_HOOKWORD(TRCID_SS_075), (Int32)(op), (Int32)(ss_ioctl_op[op]), (Int32)(kx_args), (Int32)(inode), (Int32)(file));
#define TRACE_TRCID_SS_077_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_077), (Int32)(op));
#define TRACE_TRCID_SS_081_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_081), (Int32)(major));
#define TRACE_TRCID_SS_083_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SS_083), (Int32)(GPFSIoctlMajorNumber));
#define TRACE_TRCID_UNPROT_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_UNPROT_ENTER), (Int32)(vaddr), (Int32)(len), (Int32)(allocating));
#define TRACE_TRCID_REPROT_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_REPROT_ENTER), (Int32)(vaddr), (Int32)(len));
#define TRACE_TRCID_SHKERN_INIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_SHKERN_INIT), (Int32)(VMALLOC_START), (Int32)(VMALLOC_END));
#define TRACE_TRCID_SHKERN_TERM_CALL \
    _TRACE0D(_HOOKWORD(TRCID_SHKERN_TERM));
#define TRACE_TRCID_SSINIT_003_CALL \
    _TRACE1D(_HOOKWORD(TRCID_SSINIT_003), (Int32)(GPFSIoctlMajorNumber));
#define TRACE_TRCID_CALC_MAX_SHARED_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CALC_MAX_SHARED), (Int32)(actualBytes), (Int32)(desiredBytes), (Int32)(physMemSize), (Int32)(vmUsed), (Int32)(maxBytes));
#define TRACE_TRCID_ALLOC_SHARED_VMALLOC_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ALLOC_SHARED_VMALLOC), (Int32)(actualBytes), (Int32)(minBytes));
#define TRACE_TRCID_ALLOC_SHARED_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_ALLOC_SHARED_EXIT), (Int32)(vaddrP), (Int32)(actualBytes), (Int32)(minBytes));
#define TRACE_TRCID_ALLOC_SHARED_FAIL_CALL \
    _TRACE2D(_HOOKWORD(TRCID_ALLOC_SHARED_FAIL), (Int32)(actualBytes), (Int32)(minBytes));
#define TRACE_TRCID_MAPALL_MULTI_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MAPALL_MULTI), (Int32)(chunkP));
#define TRACE_TRCID_FREEALL_VFREE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FREEALL_VFREE), (Int32)(chunkP->vaddrP), (Int32)(chunkP));
#define TRACE_TRCID_CXI_MAP_PRIVATE_CALL \
    _TRACE5D(_HOOKWORD(TRCID_CXI_MAP_PRIVATE), (Int32)(inAddr), (Int32)(len), (Int32)(prot), (Int32)(*outAddr), (Int32)(vmaP));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_1_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_1));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_2_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_2), (Int32)(page), (Int32)(page_count(page)), (Int32)(page->index), (Int32)(page->flags));
#define TRACE_TRCID_MMAP_FLUSH_DIRTY_PAGES_6_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_FLUSH_DIRTY_PAGES_6));
#define TRACE_TRCID_MMAP_FLUSH_LOCK_A_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_LOCK_A), 0, 0, buf);
#define TRACE_TRCID_MMAP_FLUSH_LOCK_B_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_LOCK_B), 0, 0, buf);
#define TRACE_TRCID_MMAP_FLUSH_UNLOCK_A_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_FLUSH_UNLOCK_A), 0, 0, buf);
#define TRACE_TRCID_MMAP_INV_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_INV_ENTER), (Int32)(vma), (Int32)(address), (Int32)(flags), (Int32)(pageP));
#define TRACE_TRCID_MMAP_INV_PRESENT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_INV_PRESENT));
#define TRACE_TRCID_MMAP_INV_PTE_NONE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_INV_PTE_NONE));
#define TRACE_TRCID_MMAP_INVALIDATE_PAGE_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MMAP_INVALIDATE_PAGE), (Int32)(pageP), (Int32)(page_count(pageP)), (Int32)(pte_dirty(pte)?1:0));
#define TRACE_TRCID_MMAP_DIRTY_PAGE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_DIRTY_PAGE), (Int32)(page), (Int32)(page_count(page)));
#define TRACE_TRCID_MMAP_WAIT_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_WAIT_ENTER));
#define TRACE_TRCID_MMAP_WAIT_EXIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_WAIT_EXIT));
#define TRACE_TRCID_MMAP_REG_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_REG_ENTER));
#define TRACE_TRCID_MMAP_REG_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_REG_EXIT), (Int32)(rc));
#define TRACE_TRCID_MMAP_UNREG_ENTER_CALL \
    _TRACE0D(_HOOKWORD(TRCID_MMAP_UNREG_ENTER));
#define TRACE_TRCID_MMAP_UNREG_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_UNREG_EXIT), (Int32)(rc));
#define TRACE_TRCID_MMAP_CREATE_EXIT_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_CREATE_EXIT), (Int32)(pid), (Int32)(rc));
#define TRACE_TRCID_MMAP_FILEPOS_ENTER_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FILEPOS_ENTER), High32(pos), Low32(pos));
#define TRACE_TRCID_MMAP_RW_ENTER_CALL \
    _STrace(_HOOKWORD(TRCID_MMAP_RW_ENTER), 4, 4, (Int32)(pageP), (Int32)(PAGE_CACHE_SIZE), (Int32)(pageP->index), (Int32)(kaddr), write_req?"write":"read");
#define TRACE_TRCID_MMAP_RW_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_RW_EXIT), (Int32)(rc));
#define TRACE_TRCID_MMAP_IO_ENTER_CALL \
    _TRACE5D(_HOOKWORD(TRCID_MMAP_IO_ENTER), (Int32)(pageP), (Int32)(bufP->b_flags), (Int32)(page_count(pageP)), (Int32)(pageP->flags), (Int32)(pageP->index));
#define TRACE_TRCID_MMAP_IO_EXIT_CALL \
    _TRACE3D(_HOOKWORD(TRCID_MMAP_IO_EXIT), (Int32)(pageP), (Int32)(page_count(pageP)), (Int32)(pageP->flags));
#define TRACE_TRCID_FLUSH_VMA_ENTER_CALL \
    _TRACE3D(_HOOKWORD(TRCID_FLUSH_VMA_ENTER), (Int32)(vma), (Int32)(address), (Int32)(size));
#define TRACE_TRCID_FLUSH_VMA_BAD_ADDR_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_ADDR));
#define TRACE_TRCID_PAGE_LOCK_CALL \
    _TRACE4D(_HOOKWORD(TRCID_PAGE_LOCK), (Int32)(vma), (Int32)(address), (Int32)(end), (Int32)(index));
#define TRACE_TRCID_FLUSH_VMA_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_EXIT), (Int32)(error));
#define TRACE_TRCID_MMAP_FLUSH_1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_1), (Int32)(vma), (Int32)(vma->vm_file->f_dentry->d_inode->i_ino));
#define TRACE_TRCID_MMAP_FLUSH_2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_2), (Int32)(vma->vm_start), (Int32)(vma->vm_end));
#define TRACE_TRCID_MMAP_FLUSH_3_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_3), (Int32)(start_address), (Int32)(end_address));
#define TRACE_TRCID_MMAP_FLUSH_4_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_FLUSH_4), (Int32)(vma));
#define TRACE_TRCID_MMAP_FLUSH_ENTER_CALL \
    _TRACE4D(_HOOKWORD(TRCID_MMAP_FLUSH_ENTER), (Int32)(gnP), (Int32)(inodeP->i_ino), (Int32)(mmfopt), (Int32)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_ENTER_A_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_ENTER_A), (Int32)((start &PAGE_MASK)), (Int32)((end & PAGE_MASK)));
#define TRACE_TRCID_MMAP_FLUSH_INVAL1_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_INVAL1), (Int32)(inodeP->i_ino), (Int32)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_INVAL2_CALL \
    _TRACE2D(_HOOKWORD(TRCID_MMAP_FLUSH_INVAL2), (Int32)(inodeP->i_ino), (Int32)(inodeP->i_data.nrpages));
#define TRACE_TRCID_MMAP_FLUSH_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_MMAP_FLUSH_EXIT), (Int32)(rc));
#define TRACE_TRCID_DUMP_OPLOCK_CALL \
    _XTrace(_HOOKWORD(TRCID_DUMP_OPLOCK), "oplock_fcntl: %s on %d (%s %s)\n", cmdstr, (Int32)(fd), omodestr, dmodestr);
#define TRACE_TRCID_NLM_SET_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_SET), (Int32)(lockmode));
#define TRACE_TRCID_NLM_RELEASE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_RELEASE), (Int32)(lockmode));
#define TRACE_TRCID_NLM_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_EXIT), (Int32)(err));
#define TRACE_TRCID_NLM_MOVE_CALL \
    _TRACE2D(_HOOKWORD(TRCID_NLM_MOVE), (Int32)(lockmode), (Int32)(nodenumber));
#define TRACE_TRCID_NLM_MOVE_EXIT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_NLM_MOVE_EXIT), (Int32)(err));
#define TRACE_TRCID_TESTMOVEOPENLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_TESTMOVEOPENLOCK), (Int32)(fd), (Int32)(cmd), (Int32)(arg));
#define TRACE_TRCID_TESTMOVERECLOCK_CALL \
    _TRACE3D(_HOOKWORD(TRCID_TESTMOVERECLOCK), (Int32)(fd), (Int32)(cmd), (Int32)(arg));
#define TRACE_TRCID_TESTCLAMPLOCKS_CALL \
    _TRACE2D(_HOOKWORD(TRCID_TESTCLAMPLOCKS), (Int32)(fd), (Int32)(clamp));
#define TRACE_TRCID_FCNTL_TOKEN_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_TOKEN), (Int32)(token_want));
#define TRACE_TRCID_FCNTL_SET_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_SET), (Int32)(err));
#define TRACE_TRCID_FCNTL_RELEASE_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_RELEASE), (Int32)(token_want));
#define TRACE_TRCID_FCNTL_TOKEN_RELEASE_CALL \
    _STrace(_HOOKWORD(TRCID_FCNTL_TOKEN_RELEASE), 4, 4, (Int32)(deny_type), (Int32)(omode), (Int32)(filp->f_dentry->d_inode->i_dev), (Int32)(filp->f_dentry->d_inode->i_ino), filp->f_dentry->d_name.name);
#define TRACE_TRCID_FCNTL_FILP_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FCNTL_FILP));
#define TRACE_TRCID_FCNTL_OPENMODE_OK_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTL_OPENMODE_OK), (Int32)(inode->i_dev), (Int32)(inode->i_ino));
#define TRACE_TRCID_FCNTL_OPENMODE_DENIED_CALL \
    _TRACE4D(_HOOKWORD(TRCID_FCNTL_OPENMODE_DENIED), (Int32)(inode->i_dev), (Int32)(inode->i_ino), (Int32)(err), (Int32)(grant));
#define TRACE_TRCID_FCNTL_OPLOCK_SHARED_CALL \
    _TRACE5D(_HOOKWORD(TRCID_FCNTL_OPLOCK_SHARED), (Int32)(grant), (Int32)(inode->i_dev), (Int32)(inode->i_ino), (Int32)((unsigned long)filp), (Int32)((unsigned long)pfilp));
#define TRACE_TRCID_FCNTL_OPLKACK_OK_CALL \
    _TRACE2D(_HOOKWORD(TRCID_FCNTL_OPLKACK_OK), (Int32)(inode->i_dev), (Int32)(inode->i_ino));
#define TRACE_TRCID_FCNTL_OPLKACK_FAIL_CALL \
    _TRACE4D(_HOOKWORD(TRCID_FCNTL_OPLKACK_FAIL), (Int32)(inode->i_dev), (Int32)(inode->i_ino), (Int32)(grant), (Int32)(err));
#define TRACE_TRCID_FCNTL_STAT_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FCNTL_STAT), (Int32)(err));
#define TRACE_TRCID_OPLOCK_INIT_CALL \
    _TRACE0D(_HOOKWORD(TRCID_OPLOCK_INIT));
#define TRACE_TRCID_FLUSH_VMA_PGT_LOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PGT_LOCK), (Int32)(vma));
#define TRACE_TRCID_FLUSH_VMA_BAD_PGD_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PGD));
#define TRACE_TRCID_FLUSH_VMA_BAD_PMD_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PMD));
#define TRACE_TRCID_FLUSH_VMA_BAD_PTE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_BAD_PTE));
#define TRACE_TRCID_FLUSH_VMA_NONE_PTE_CALL \
    _TRACE0D(_HOOKWORD(TRCID_FLUSH_VMA_NONE_PTE));
#define TRACE_TRCID_FLUSH_VMA_PAGE_LOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PAGE_LOCK), (Int32)(page));
#define TRACE_TRCID_FLUSH_VMA_PGT_UNLOCK_CALL \
    _TRACE1D(_HOOKWORD(TRCID_FLUSH_VMA_PGT_UNLOCK), (Int32)(vma));

#endif /* __64BIT__ */
